/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.configuration;

import java.util.Map;

public interface Accessor {
    public Boolean getBoolean(String var1);

    public Integer getInt(String var1);

    public Long getLong(String var1);

    public String getString(String var1);

    public Float getFloat(String var1);

    public static class MapAccessor
    implements Accessor {
        private Map<Object, Object> source;

        public MapAccessor(Map<Object, Object> map) {
            this.source = map;
        }

        protected void setSource(Map<Object, Object> source) {
            this.source = source;
        }

        @Override
        public Boolean getBoolean(String name) {
            if (this.source != null && this.source.containsKey(name)) {
                if (this.source.get(name) instanceof Boolean) {
                    return (Boolean)this.source.get(name);
                }
                return Boolean.parseBoolean((String)this.source.get(name));
            }
            return null;
        }

        @Override
        public Integer getInt(String name) {
            if (this.source != null && this.source.containsKey(name)) {
                if (this.source.get(name) instanceof Integer) {
                    return (Integer)this.source.get(name);
                }
                return Integer.parseInt((String)this.source.get(name));
            }
            return null;
        }

        @Override
        public Long getLong(String name) {
            if (this.source != null && this.source.containsKey(name)) {
                if (this.source.get(name) instanceof Long) {
                    return (Long)this.source.get(name);
                }
                return Long.parseLong((String)this.source.get(name));
            }
            return null;
        }

        @Override
        public String getString(String name) {
            if (this.source != null && this.source.containsKey(name)) {
                if (this.source.get(name) instanceof String) {
                    return (String)this.source.get(name);
                }
                return String.valueOf(this.source.get(name));
            }
            return null;
        }

        @Override
        public Float getFloat(String name) {
            if (this.source != null && this.source.containsKey(name)) {
                if (this.source.get(name) instanceof Float) {
                    return (Float)this.source.get(name);
                }
                return Float.valueOf(Float.parseFloat((String)this.source.get(name)));
            }
            return null;
        }
    }

    public static class SystemPropertyAccessor
    implements Accessor {
        @Override
        public Boolean getBoolean(String name) {
            return System.getProperty(name) == null ? null : Boolean.valueOf(Boolean.getBoolean(name));
        }

        @Override
        public Integer getInt(String name) {
            return Integer.getInteger(name);
        }

        @Override
        public Long getLong(String name) {
            return Long.getLong(name);
        }

        @Override
        public String getString(String name) {
            return System.getProperty(name);
        }

        @Override
        public Float getFloat(String name) {
            return System.getProperty(name) == null ? null : Float.valueOf(Float.parseFloat(System.getProperty(name)));
        }
    }
}

