/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ExtendedDataInput;

public class ByteArrayDataInput
implements ExtendedDataInput,
MarkableDataInput {
    private byte[] _data;
    private int _offset;
    private int _length;
    private int _origin;
    private int _mark;

    public ByteArrayDataInput(byte[] data) {
        this(data, 0, data.length);
    }

    public ByteArrayDataInput(byte[] data, int offset, int length) {
        this._data = data;
        this._offset = offset;
        this._length = length;
        this._origin = offset;
        this._mark = 0;
    }

    @Override
    public void readFully(byte[] b) {
        System.arraycopy(this._data, this._offset, b, 0, b.length);
        this._offset += b.length;
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        System.arraycopy(this._data, this._offset, b, off, len);
        this._offset += len;
    }

    @Override
    public int skipBytes(int n) {
        return this._offset += n;
    }

    @Override
    public boolean readBoolean() {
        return this._data[this._offset++] != 0;
    }

    @Override
    public byte readByte() {
        return this._data[this._offset++];
    }

    @Override
    public int readUnsignedByte() {
        return this._data[this._offset++] & 0xFF;
    }

    @Override
    public short readShort() {
        return (short)(this._data[this._offset++] << 8 & 0xFF00 | this._data[this._offset++] & 0xFF);
    }

    @Override
    public int readUnsignedShort() {
        return this._data[this._offset++] << 8 & 0xFF00 | this._data[this._offset++] & 0xFF;
    }

    @Override
    public char readChar() {
        return (char)(this._data[this._offset++] << 8 & 0xFF00 | this._data[this._offset++] & 0xFF);
    }

    @Override
    public int readInt() {
        return this._data[this._offset++] << 24 & 0xFF000000 | this._data[this._offset++] << 16 & 0xFF0000 | this._data[this._offset++] << 8 & 0xFF00 | this._data[this._offset++] & 0xFF;
    }

    @Override
    public long readLong() {
        return (long)this._data[this._offset++] << 56 & 0xFF00000000000000L | (long)this._data[this._offset++] << 48 & 0xFF000000000000L | (long)this._data[this._offset++] << 40 & 0xFF0000000000L | (long)this._data[this._offset++] << 32 & 0xFF00000000L | (long)this._data[this._offset++] << 24 & 0xFF000000L | (long)this._data[this._offset++] << 16 & 0xFF0000L | (long)this._data[this._offset++] << 8 & 0xFF00L | (long)this._data[this._offset++] & 0xFFL;
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public AMQShortString readAMQShortString() {
        int length;
        if ((length = this._data[this._offset++] & 0xFF) == 0) {
            return null;
        }
        AMQShortString amqShortString = new AMQShortString(this._data, this._offset, length);
        this._offset += length;
        return amqShortString;
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() {
        return this._origin + this._length - this._offset;
    }

    @Override
    public long skip(long i) {
        this._offset = (int)((long)this._offset + i);
        return i;
    }

    @Override
    public int read(byte[] b) {
        this.readFully(b);
        return b.length;
    }

    @Override
    public int position() {
        return this._offset - this._origin;
    }

    @Override
    public void position(int position) {
        this._offset = position + this._origin;
    }

    public int length() {
        return this._length;
    }

    @Override
    public void mark(int readAhead) {
        this._mark = this._offset - this._origin;
    }

    @Override
    public void reset() {
        this._offset = this._origin + this._mark;
    }
}

