/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.MessageAppendBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class MessageAppendBodyImpl
extends AMQMethodBody_0_9
implements MessageAppendBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new MessageAppendBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 80;
    private final byte[] _reference;
    private final byte[] _bytes;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public MessageAppendBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._reference = this.readBytes(buffer);
        this._bytes = this.readBytes(buffer);
    }

    public MessageAppendBodyImpl(byte[] reference, byte[] bytes) {
        this._reference = reference;
        this._bytes = bytes;
    }

    @Override
    public int getClazz() {
        return 120;
    }

    @Override
    public int getMethod() {
        return 80;
    }

    @Override
    public final byte[] getReference() {
        return this._reference;
    }

    @Override
    public final byte[] getBytes() {
        return this._bytes;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._reference);
        return size += this.getSizeOf(this._bytes);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeBytes(buffer, this._reference);
        this.writeBytes(buffer, this._bytes);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchMessageAppend(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[MessageAppendBodyImpl: ");
        buf.append("reference=");
        buf.append(this.getReference() == null ? "null" : Arrays.toString(this.getReference()));
        buf.append(", ");
        buf.append("bytes=");
        buf.append(this.getBytes() == null ? "null" : Arrays.toString(this.getBytes()));
        buf.append("]");
        return buf.toString();
    }
}

