/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.MessageOpenBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class MessageOpenBodyImpl
extends AMQMethodBody_0_9
implements MessageOpenBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new MessageOpenBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 60;
    private final byte[] _reference;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public MessageOpenBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._reference = this.readBytes(buffer);
    }

    public MessageOpenBodyImpl(byte[] reference) {
        this._reference = reference;
    }

    @Override
    public int getClazz() {
        return 120;
    }

    @Override
    public int getMethod() {
        return 60;
    }

    @Override
    public final byte[] getReference() {
        return this._reference;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._reference);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeBytes(buffer, this._reference);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchMessageOpen(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[MessageOpenBodyImpl: ");
        buf.append("reference=");
        buf.append(this.getReference() == null ? "null" : Arrays.toString(this.getReference()));
        buf.append("]");
        return buf.toString();
    }
}

