/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.abstraction.AbstractMethodConverter;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.framing.abstraction.MessagePublishInfoImpl;
import org.apache.qpid.framing.abstraction.ProtocolVersionMethodConverter;
import org.apache.qpid.framing.amqp_0_9.BasicPublishBodyImpl;

public class MethodConverter_0_9
extends AbstractMethodConverter
implements ProtocolVersionMethodConverter {
    private int _basicPublishClassId;
    private int _basicPublishMethodId;

    public MethodConverter_0_9() {
        super((byte)0, (byte)9);
    }

    @Override
    public AMQBody convertToBody(ContentChunk contentChunk) {
        if (contentChunk instanceof ContentChunk_0_9) {
            return ((ContentChunk_0_9)contentChunk).toBody();
        }
        return new ContentBody(contentChunk.getData());
    }

    @Override
    public ContentChunk convertToContentChunk(AMQBody body) {
        ContentBody contentBodyChunk = (ContentBody)body;
        return new ContentChunk_0_9(contentBodyChunk);
    }

    @Override
    public void configure() {
        this._basicPublishClassId = 60;
        this._basicPublishMethodId = 40;
    }

    @Override
    public AMQBody convertToBody(byte[] data) {
        return new ContentBody(data);
    }

    @Override
    public MessagePublishInfo convertToInfo(AMQMethodBody methodBody) {
        BasicPublishBody publishBody = (BasicPublishBody)methodBody;
        AMQShortString exchange = publishBody.getExchange();
        AMQShortString routingKey = publishBody.getRoutingKey();
        return new MessagePublishInfoImpl(exchange, publishBody.getImmediate(), publishBody.getMandatory(), routingKey);
    }

    @Override
    public AMQMethodBody convertToBody(MessagePublishInfo info) {
        return new BasicPublishBodyImpl(0, info.getExchange(), info.getRoutingKey(), info.isMandatory(), info.isImmediate());
    }

    private static class ContentChunk_0_9
    implements ContentChunk {
        private final ContentBody _contentBodyChunk;

        public ContentChunk_0_9(ContentBody contentBodyChunk) {
            this._contentBodyChunk = contentBodyChunk;
        }

        @Override
        public int getSize() {
            return this._contentBodyChunk.getSize();
        }

        @Override
        public byte[] getData() {
            return this._contentBodyChunk.getPayload();
        }

        @Override
        public void reduceToFit() {
            this._contentBodyChunk.reduceBufferToFit();
        }

        public AMQBody toBody() {
            return this._contentBodyChunk;
        }
    }
}

