/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.AccessRequestBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class AccessRequestBodyImpl
extends AMQMethodBody_8_0
implements AccessRequestBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new AccessRequestBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 30;
    public static final int METHOD_ID = 10;
    private final AMQShortString _realm;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public AccessRequestBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._realm = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public AccessRequestBodyImpl(AMQShortString realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
        this._realm = realm;
        byte bitfield0 = 0;
        if (exclusive) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (passive) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (active) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        if (write) {
            bitfield0 = (byte)(bitfield0 | 8);
        }
        if (read) {
            bitfield0 = (byte)(bitfield0 | 0x10);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 30;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    @Override
    public final AMQShortString getRealm() {
        return this._realm;
    }

    @Override
    public final boolean getExclusive() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final boolean getPassive() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    public final boolean getActive() {
        return (this._bitfield0 & 4) != 0;
    }

    @Override
    public final boolean getWrite() {
        return (this._bitfield0 & 8) != 0;
    }

    @Override
    public final boolean getRead() {
        return (this._bitfield0 & 0x10) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 1;
        return size += this.getSizeOf(this._realm);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._realm);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchAccessRequest(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[AccessRequestBodyImpl: ");
        buf.append("realm=");
        buf.append(this.getRealm());
        buf.append(", ");
        buf.append("exclusive=");
        buf.append(this.getExclusive());
        buf.append(", ");
        buf.append("passive=");
        buf.append(this.getPassive());
        buf.append(", ");
        buf.append("active=");
        buf.append(this.getActive());
        buf.append(", ");
        buf.append("write=");
        buf.append(this.getWrite());
        buf.append(", ");
        buf.append("read=");
        buf.append(this.getRead());
        buf.append("]");
        return buf.toString();
    }
}

