/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocket;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.thread.Threading;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.Ticker;
import org.apache.qpid.transport.util.Logger;

final class IoReceiver
implements Runnable,
Closeable {
    private static final Logger log = Logger.get(IoReceiver.class);
    private final Receiver<ByteBuffer> receiver;
    private final int bufferSize;
    private final Socket socket;
    private final long timeout;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Thread receiverThread;
    private static final boolean shutdownBroken;
    private Ticker _ticker;

    public IoReceiver(Socket socket, Receiver<ByteBuffer> receiver, int bufferSize, long timeout) {
        this.receiver = receiver;
        this.bufferSize = bufferSize;
        this.socket = socket;
        this.timeout = timeout;
        try {
            this.receiverThread = Threading.getThreadFactory().createThread(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating IOReceiver thread", e);
        }
        this.receiverThread.setDaemon(true);
        this.receiverThread.setName(String.format("IoReceiver - %s", socket.getRemoteSocketAddress()));
    }

    public void initiate() {
        this.receiverThread.start();
    }

    @Override
    public void close() {
        this.close(false);
    }

    void close(boolean block) {
        if (!this.closed.getAndSet(true)) {
            try {
                block10: {
                    try {
                        if (shutdownBroken || this.socket instanceof SSLSocket) {
                            this.socket.close();
                        } else {
                            this.socket.shutdownInput();
                        }
                    }
                    catch (SocketException se) {
                        if (this.socket.isClosed() || this.socket.isInputShutdown()) break block10;
                        throw se;
                    }
                }
                if (block && Thread.currentThread() != this.receiverThread) {
                    this.receiverThread.join(this.timeout);
                    if (this.receiverThread.isAlive()) {
                        throw new TransportException("join timed out");
                    }
                }
            }
            catch (InterruptedException e) {
                throw new TransportException(e);
            }
            catch (IOException e) {
                throw new TransportException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int threshold = this.bufferSize / 2;
        byte[] buffer = new byte[this.bufferSize];
        try {
            InputStream in = this.socket.getInputStream();
            int read = 0;
            int offset = 0;
            block17: while (read != -1) {
                block18: while (true) {
                    long currentTime;
                    try {
                        while ((read = in.read(buffer, offset, this.bufferSize - offset)) != -1) {
                            if (read > 0) {
                                ByteBuffer b = ByteBuffer.wrap(buffer, offset, read);
                                this.receiver.received(b);
                                if ((offset += read) > threshold) {
                                    offset = 0;
                                    buffer = new byte[this.bufferSize];
                                }
                            }
                            currentTime = System.currentTimeMillis();
                            if (this._ticker == null) continue;
                            int tick = this._ticker.getTimeToNextTick(currentTime);
                            if (tick <= 0) {
                                tick = this._ticker.tick(currentTime);
                            }
                            try {
                                if (this.socket.isClosed()) continue block18;
                                this.socket.setSoTimeout(tick <= 0 ? 1 : tick);
                                continue block18;
                            }
                            catch (SocketException e) {
                            }
                        }
                        continue block17;
                    }
                    catch (SocketTimeoutException e) {
                        currentTime = System.currentTimeMillis();
                        if (this._ticker == null) continue block17;
                        int tick = this._ticker.tick(currentTime);
                        if (this.socket.isClosed()) continue block17;
                        try {
                            this.socket.setSoTimeout(tick <= 0 ? 1 : tick);
                        }
                        catch (SocketException ex) {}
                        continue block17;
                    }
                }
            }
        }
        catch (Throwable t) {
            if (this.shouldReport(t)) {
                this.receiver.exception(t);
            }
        }
        finally {
            this.receiver.closed();
            try {
                this.socket.close();
            }
            catch (Exception e) {
                log.warn(e, "Error closing socket", new Object[0]);
            }
        }
    }

    private boolean shouldReport(Throwable t) {
        boolean brokenClose = this.closed.get() && shutdownBroken && t instanceof SocketException && "socket closed".equalsIgnoreCase(t.getMessage());
        boolean sslSocketClosed = this.closed.get() && this.socket instanceof SSLSocket && t instanceof SocketException && "Socket is closed".equalsIgnoreCase(t.getMessage());
        return !brokenClose && !sslSocketClosed;
    }

    public Ticker getTicker() {
        return this._ticker;
    }

    public void setTicker(Ticker ticker) {
        this._ticker = ticker;
    }

    static {
        String osName = System.getProperty("os.name");
        shutdownBroken = osName == null ? false : osName.matches("(?i).*windows.*");
    }
}

