/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.ssl;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.security.SSLStatus;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.transport.util.Logger;

public class SSLReceiver
implements Receiver<ByteBuffer> {
    private static final Logger log = Logger.get(SSLReceiver.class);
    private final Receiver<ByteBuffer> delegate;
    private final SSLEngine engine;
    private final int sslBufSize;
    private final ByteBuffer localBuffer;
    private final SSLStatus _sslStatus;
    private ByteBuffer appData;
    private boolean dataCached = false;
    private String _hostname;

    public SSLReceiver(SSLEngine engine, Receiver<ByteBuffer> delegate, SSLStatus sslStatus) {
        this.engine = engine;
        this.delegate = delegate;
        this.sslBufSize = engine.getSession().getApplicationBufferSize();
        this.appData = ByteBuffer.allocate(this.sslBufSize);
        this.localBuffer = ByteBuffer.allocate(this.sslBufSize);
        this._sslStatus = sslStatus;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname;
    }

    @Override
    public void closed() {
        this.delegate.closed();
    }

    @Override
    public void exception(Throwable t) {
        this.delegate.exception(t);
    }

    private ByteBuffer addPreviouslyUnreadData(ByteBuffer buf) {
        if (this.dataCached) {
            ByteBuffer b = ByteBuffer.allocate(this.localBuffer.remaining() + buf.remaining());
            b.put(this.localBuffer);
            b.put(buf);
            b.flip();
            this.dataCached = false;
            return b;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received(ByteBuffer buf) {
        ByteBuffer netData = this.addPreviouslyUnreadData(buf);
        block26: while (netData.hasRemaining()) {
            try {
                SSLEngineResult result = this.engine.unwrap(netData, this.appData);
                Object object = this._sslStatus.getSslLock();
                synchronized (object) {
                    this._sslStatus.getSslLock().notifyAll();
                }
                int read = result.bytesProduced();
                SSLEngineResult.Status status = result.getStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                if (read > 0) {
                    int limit = this.appData.limit();
                    this.appData.limit(this.appData.position());
                    this.appData.position(this.appData.position() - read);
                    ByteBuffer data = this.appData.slice();
                    this.appData.limit(limit);
                    this.appData.position(this.appData.position() + read);
                    this.delegate.received(data);
                }
                switch (status) {
                    case CLOSED: {
                        Object object2 = this._sslStatus.getSslLock();
                        synchronized (object2) {
                            this._sslStatus.getSslLock().notifyAll();
                        }
                        return;
                    }
                    case BUFFER_OVERFLOW: {
                        this.appData = ByteBuffer.allocate(this.sslBufSize);
                        continue block26;
                    }
                    case BUFFER_UNDERFLOW: {
                        this.localBuffer.clear();
                        this.localBuffer.put(netData);
                        this.localBuffer.flip();
                        this.dataCached = true;
                        break;
                    }
                    case OK: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("SSLReceiver: Invalid State " + (Object)((Object)status));
                    }
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        if (!netData.hasRemaining()) continue block26;
                        continue block26;
                    }
                    case NEED_TASK: {
                        this.doTasks();
                        handshakeStatus = this.engine.getHandshakeStatus();
                    }
                    case FINISHED: {
                        if (this._hostname != null) {
                            SSLUtil.verifyHostname(this.engine, this._hostname);
                        }
                    }
                    case NEED_WRAP: 
                    case NOT_HANDSHAKING: {
                        Object object3 = this._sslStatus.getSslLock();
                        synchronized (object3) {
                            this._sslStatus.getSslLock().notifyAll();
                            break;
                        }
                    }
                    default: {
                        throw new IllegalStateException("SSLReceiver: Invalid State " + (Object)((Object)status));
                    }
                }
            }
            catch (SSLException e) {
                log.error(e, "Error caught in SSLReceiver", new Object[0]);
                this._sslStatus.setSslErrorFlag();
                Object object = this._sslStatus.getSslLock();
                synchronized (object) {
                    this._sslStatus.getSslLock().notifyAll();
                }
                this.exception(new TransportException("Error in SSLReceiver", e));
            }
        }
    }

    private void doTasks() {
        Runnable runnable;
        while ((runnable = this.engine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }
}

