/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.bytebuffer;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.qpid.bytebuffer.ByteBufferRef;
import org.apache.qpid.bytebuffer.QpidByteBuffer;

class PooledByteBufferRef
implements ByteBufferRef {
    private static final AtomicIntegerFieldUpdater<PooledByteBufferRef> REF_COUNT = AtomicIntegerFieldUpdater.newUpdater(PooledByteBufferRef.class, "_refCount");
    private final ByteBuffer _buffer;
    private volatile int _refCount;

    PooledByteBufferRef(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    @Override
    public void incrementRef() {
        if (REF_COUNT.get(this) >= 0) {
            REF_COUNT.incrementAndGet(this);
        }
    }

    @Override
    public void decrementRef() {
        if (REF_COUNT.get(this) > 0 && REF_COUNT.decrementAndGet(this) == 0) {
            QpidByteBuffer.returnToPool(this._buffer);
        }
    }

    @Override
    public ByteBuffer getBuffer() {
        return this._buffer.duplicate();
    }

    @Override
    public void removeFromPool() {
        REF_COUNT.set(this, -1073741824);
    }
}

