/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.bytebuffer;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.bytebuffer.BufferPool;
import org.apache.qpid.bytebuffer.ByteBufferRef;
import org.apache.qpid.bytebuffer.NonPooledByteBufferRef;
import org.apache.qpid.bytebuffer.PooledByteBufferRef;
import org.apache.qpid.bytebuffer.QpidByteBufferOutputStream;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.streams.CompositeInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QpidByteBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpidByteBuffer.class);
    private static final AtomicIntegerFieldUpdater<QpidByteBuffer> DISPOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(QpidByteBuffer.class, "_disposed");
    private static final ThreadLocal<QpidByteBuffer> _cachedBuffer = new ThreadLocal();
    private volatile ByteBuffer _buffer;
    private final ByteBufferRef _ref;
    private volatile int _disposed;
    private static volatile boolean _isPoolInitialized;
    private static volatile BufferPool _bufferPool;
    private static volatile int _pooledBufferSize;
    private static volatile ByteBuffer _zeroed;

    QpidByteBuffer(ByteBufferRef ref) {
        this(ref.getBuffer(), ref);
    }

    private QpidByteBuffer(ByteBuffer buf, ByteBufferRef ref) {
        this._buffer = buf;
        this._ref = ref;
        ref.incrementRef();
    }

    public boolean hasRemaining() {
        return this._buffer.hasRemaining();
    }

    public QpidByteBuffer putInt(int index, int value) {
        this._buffer.putInt(index, value);
        return this;
    }

    public boolean isDirect() {
        return this._buffer.isDirect();
    }

    public QpidByteBuffer putShort(int index, short value) {
        this._buffer.putShort(index, value);
        return this;
    }

    public QpidByteBuffer putChar(int index, char value) {
        this._buffer.putChar(index, value);
        return this;
    }

    public QpidByteBuffer put(byte b) {
        this._buffer.put(b);
        return this;
    }

    public QpidByteBuffer put(int index, byte b) {
        this._buffer.put(index, b);
        return this;
    }

    public short getShort(int index) {
        return this._buffer.getShort(index);
    }

    public QpidByteBuffer mark() {
        this._buffer.mark();
        return this;
    }

    public long getLong() {
        return this._buffer.getLong();
    }

    public QpidByteBuffer putFloat(int index, float value) {
        this._buffer.putFloat(index, value);
        return this;
    }

    public double getDouble(int index) {
        return this._buffer.getDouble(index);
    }

    public boolean hasArray() {
        return this._buffer.hasArray();
    }

    public QpidByteBuffer asReadOnlyBuffer() {
        return new QpidByteBuffer(this._buffer.asReadOnlyBuffer(), this._ref);
    }

    public double getDouble() {
        return this._buffer.getDouble();
    }

    public QpidByteBuffer putFloat(float value) {
        this._buffer.putFloat(value);
        return this;
    }

    public QpidByteBuffer putInt(int value) {
        this._buffer.putInt(value);
        return this;
    }

    public byte[] array() {
        return this._buffer.array();
    }

    public QpidByteBuffer putShort(short value) {
        this._buffer.putShort(value);
        return this;
    }

    public int getInt(int index) {
        return this._buffer.getInt(index);
    }

    public int remaining() {
        return this._buffer.remaining();
    }

    public QpidByteBuffer put(byte[] src) {
        this._buffer.put(src);
        return this;
    }

    public QpidByteBuffer put(ByteBuffer src) {
        this._buffer.put(src);
        return this;
    }

    public QpidByteBuffer put(QpidByteBuffer src) {
        this._buffer.put(src._buffer);
        return this;
    }

    public QpidByteBuffer get(byte[] dst, int offset, int length) {
        this._buffer.get(dst, offset, length);
        return this;
    }

    public QpidByteBuffer get(ByteBuffer dst) {
        dst.put(this._buffer);
        return this;
    }

    public void copyTo(ByteBuffer dst) {
        dst.put(this._buffer.duplicate());
    }

    public void putCopyOf(QpidByteBuffer buf) {
        this._buffer.put(buf._buffer.duplicate());
    }

    public QpidByteBuffer rewind() {
        this._buffer.rewind();
        return this;
    }

    public QpidByteBuffer clear() {
        this._buffer.clear();
        return this;
    }

    public QpidByteBuffer putLong(int index, long value) {
        this._buffer.putLong(index, value);
        return this;
    }

    public QpidByteBuffer compact() {
        this._buffer.compact();
        return this;
    }

    public QpidByteBuffer putDouble(double value) {
        this._buffer.putDouble(value);
        return this;
    }

    public int limit() {
        return this._buffer.limit();
    }

    public QpidByteBuffer reset() {
        this._buffer.reset();
        return this;
    }

    public QpidByteBuffer flip() {
        this._buffer.flip();
        return this;
    }

    public short getShort() {
        return this._buffer.getShort();
    }

    public float getFloat() {
        return this._buffer.getFloat();
    }

    public QpidByteBuffer limit(int newLimit) {
        this._buffer.limit(newLimit);
        return this;
    }

    public QpidByteBuffer duplicate() {
        return new QpidByteBuffer(this._buffer.duplicate(), this._ref);
    }

    public QpidByteBuffer put(byte[] src, int offset, int length) {
        this._buffer.put(src, offset, length);
        return this;
    }

    public long getLong(int index) {
        return this._buffer.getLong(index);
    }

    public int capacity() {
        return this._buffer.capacity();
    }

    public boolean isReadOnly() {
        return this._buffer.isReadOnly();
    }

    public char getChar(int index) {
        return this._buffer.getChar(index);
    }

    public byte get() {
        return this._buffer.get();
    }

    public byte get(int index) {
        return this._buffer.get(index);
    }

    public QpidByteBuffer get(byte[] dst) {
        this._buffer.get(dst);
        return this;
    }

    public void copyTo(byte[] dst) {
        this._buffer.duplicate().get(dst);
    }

    public QpidByteBuffer putChar(char value) {
        this._buffer.putChar(value);
        return this;
    }

    public QpidByteBuffer position(int newPosition) {
        this._buffer.position(newPosition);
        return this;
    }

    public int arrayOffset() {
        return this._buffer.arrayOffset();
    }

    public char getChar() {
        return this._buffer.getChar();
    }

    public int getInt() {
        return this._buffer.getInt();
    }

    public QpidByteBuffer putLong(long value) {
        this._buffer.putLong(value);
        return this;
    }

    public float getFloat(int index) {
        return this._buffer.getFloat(index);
    }

    public QpidByteBuffer slice() {
        return new QpidByteBuffer(this._buffer.slice(), this._ref);
    }

    public QpidByteBuffer view(int offset, int length) {
        ByteBuffer buf = this._buffer.slice();
        buf.position(offset);
        buf.limit(offset + Math.min(length, buf.remaining()));
        buf = buf.slice();
        return new QpidByteBuffer(buf, this._ref);
    }

    public int position() {
        return this._buffer.position();
    }

    public QpidByteBuffer putDouble(int index, double value) {
        this._buffer.putDouble(index, value);
        return this;
    }

    public void dispose() {
        if (DISPOSED_UPDATER.compareAndSet(this, 0, 1)) {
            this._ref.decrementRef();
            this._buffer = null;
        }
    }

    public InputStream asInputStream() {
        return new BufferInputStream();
    }

    public MarkableDataInput asDataInput() {
        return new BufferDataInput();
    }

    public DataOutput asDataOutput() {
        return new BufferDataOutput();
    }

    public static QpidByteBuffer allocate(int size) {
        return new QpidByteBuffer(new NonPooledByteBufferRef(ByteBuffer.allocate(size)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static QpidByteBuffer allocateDirect(int size) {
        void var1_5;
        if (size < 0) {
            throw new IllegalArgumentException("Cannot allocate QpidByteBuffer with size " + size + " which is negative.");
        }
        if (_isPoolInitialized && _pooledBufferSize >= size) {
            if (_pooledBufferSize == size) {
                ByteBuffer buf = _bufferPool.getBuffer();
                if (buf == null) {
                    buf = ByteBuffer.allocateDirect(size);
                }
                PooledByteBufferRef pooledByteBufferRef = new PooledByteBufferRef(buf);
                return new QpidByteBuffer((ByteBufferRef)var1_5);
            }
            QpidByteBuffer buf = _cachedBuffer.get();
            if (buf == null || buf.remaining() < size) {
                if (buf != null) {
                    buf.dispose();
                }
                buf = QpidByteBuffer.allocateDirect(_pooledBufferSize);
            }
            QpidByteBuffer rVal = buf.view(0, size);
            buf.position(buf.position() + size);
            _cachedBuffer.set(buf);
            return rVal;
        }
        NonPooledByteBufferRef nonPooledByteBufferRef = new NonPooledByteBufferRef(ByteBuffer.allocateDirect(size));
        return new QpidByteBuffer((ByteBufferRef)var1_5);
    }

    public static Collection<QpidByteBuffer> allocateDirectCollection(int size) {
        if (_pooledBufferSize == 0) {
            return Collections.singleton(QpidByteBuffer.allocateDirect(size));
        }
        ArrayList<QpidByteBuffer> buffers = new ArrayList<QpidByteBuffer>(size / _pooledBufferSize + 2);
        int remaining = size;
        QpidByteBuffer buf = _cachedBuffer.get();
        if (buf == null) {
            buf = QpidByteBuffer.allocateDirect(_pooledBufferSize);
        }
        while (remaining > buf.remaining()) {
            int bufRemaining = buf.remaining();
            if (buf == _cachedBuffer.get()) {
                buffers.add(buf.view(0, bufRemaining));
                buf.dispose();
            } else {
                buffers.add(buf);
            }
            remaining -= bufRemaining;
            buf = QpidByteBuffer.allocateDirect(_pooledBufferSize);
        }
        buffers.add(buf.view(0, remaining));
        buf.position(buf.position() + remaining);
        if (buf.hasRemaining()) {
            _cachedBuffer.set(buf);
        } else {
            _cachedBuffer.set(QpidByteBuffer.allocateDirect(_pooledBufferSize));
            buf.dispose();
        }
        return buffers;
    }

    public ByteBuffer asByteBuffer() {
        this._ref.removeFromPool();
        return this._buffer;
    }

    public CharBuffer decode(Charset charset) {
        return charset.decode(this._buffer);
    }

    public int read(ReadableByteChannel channel) throws IOException {
        return channel.read(this._buffer);
    }

    public SSLEngineResult decryptSSL(SSLEngine engine, QpidByteBuffer dest) throws SSLException {
        return engine.unwrap(this._buffer, dest._buffer);
    }

    public static SSLEngineResult encryptSSL(SSLEngine engine, Collection<QpidByteBuffer> buffers, QpidByteBuffer dest) throws SSLException {
        ByteBuffer[] src = new ByteBuffer[buffers.size()];
        Iterator<QpidByteBuffer> iter = buffers.iterator();
        for (int i = 0; i < src.length; ++i) {
            src[i] = iter.next()._buffer;
        }
        return engine.wrap(src, dest._buffer);
    }

    public static Collection<QpidByteBuffer> inflate(Collection<QpidByteBuffer> compressedBuffers) throws IOException {
        if (compressedBuffers == null) {
            throw new IllegalArgumentException("compressedBuffers cannot be null");
        }
        boolean isDirect = false;
        ArrayList<InputStream> streams = new ArrayList<InputStream>(compressedBuffers.size());
        for (QpidByteBuffer buffer : compressedBuffers) {
            isDirect = isDirect || buffer.isDirect();
            streams.add(buffer.asInputStream());
        }
        int bufferSize = isDirect && _pooledBufferSize > 0 ? _pooledBufferSize : 65536;
        ArrayList<QpidByteBuffer> uncompressedBuffers = new ArrayList<QpidByteBuffer>();
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(new CompositeInputStream(streams));){
            int read;
            byte[] buf = new byte[bufferSize];
            while ((read = gzipInputStream.read(buf)) != -1) {
                QpidByteBuffer output = isDirect ? QpidByteBuffer.allocateDirect(read) : QpidByteBuffer.allocate(read);
                output.put(buf, 0, read);
                output.flip();
                uncompressedBuffers.add(output);
            }
            ArrayList<QpidByteBuffer> arrayList = uncompressedBuffers;
            return arrayList;
        }
    }

    public static Collection<QpidByteBuffer> deflate(Collection<QpidByteBuffer> uncompressedBuffers) throws IOException {
        if (uncompressedBuffers == null) {
            throw new IllegalArgumentException("uncompressedBuffers cannot be null");
        }
        boolean isDirect = false;
        ArrayList<InputStream> streams = new ArrayList<InputStream>(uncompressedBuffers.size());
        for (QpidByteBuffer buffer : uncompressedBuffers) {
            isDirect = isDirect || buffer.isDirect();
            streams.add(buffer.asInputStream());
        }
        int bufferSize = isDirect && _pooledBufferSize > 0 ? _pooledBufferSize : 65536;
        QpidByteBufferOutputStream compressedOutput = new QpidByteBufferOutputStream(isDirect, bufferSize);
        try (CompositeInputStream compressedInput = new CompositeInputStream(streams);
             GZIPOutputStream gzipStream = new GZIPOutputStream(new BufferedOutputStream(compressedOutput, bufferSize));){
            int read;
            byte[] buf = new byte[16384];
            while ((read = ((InputStream)compressedInput).read(buf)) > -1) {
                gzipStream.write(buf, 0, read);
            }
        }
        return compressedOutput.fetchAccumulatedBuffers();
    }

    public static long write(GatheringByteChannel channel, Collection<QpidByteBuffer> buffers) throws IOException {
        ByteBuffer[] bufs = new ByteBuffer[buffers.size()];
        Iterator<QpidByteBuffer> bufIter = buffers.iterator();
        for (int i = 0; i < bufs.length; ++i) {
            bufs[i] = bufIter.next()._buffer;
        }
        return channel.write(bufs);
    }

    public static QpidByteBuffer wrap(ByteBuffer wrap) {
        return new QpidByteBuffer(new NonPooledByteBufferRef(wrap));
    }

    public static QpidByteBuffer wrap(byte[] data) {
        return QpidByteBuffer.wrap(ByteBuffer.wrap(data));
    }

    public static QpidByteBuffer wrap(byte[] data, int offset, int length) {
        return QpidByteBuffer.wrap(ByteBuffer.wrap(data, offset, length));
    }

    static void returnToPool(ByteBuffer buffer) {
        buffer.clear();
        ByteBuffer duplicate = _zeroed.duplicate();
        duplicate.limit(buffer.capacity());
        buffer.put(duplicate);
        _bufferPool.returnBuffer(buffer);
    }

    public static synchronized void initialisePool(int bufferSize, int maxPoolSize) {
        if (_isPoolInitialized && (bufferSize != _pooledBufferSize || maxPoolSize != _bufferPool.getMaxSize())) {
            String errorMessage = String.format("QpidByteBuffer pool has already been initialised with bufferSize=%d and maxPoolSize=%d.Re-initialisation with different bufferSize=%d and maxPoolSize=%d is not allowed.", _pooledBufferSize, _bufferPool.getMaxSize(), bufferSize, maxPoolSize);
            throw new IllegalStateException(errorMessage);
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Negative or zero bufferSize illegal : " + bufferSize);
        }
        _bufferPool = new BufferPool(maxPoolSize);
        _pooledBufferSize = bufferSize;
        _zeroed = ByteBuffer.allocateDirect(_pooledBufferSize);
        _isPoolInitialized = true;
    }

    private final class BufferDataOutput
    implements DataOutput {
        private BufferDataOutput() {
        }

        @Override
        public void write(int b) {
            QpidByteBuffer.this._buffer.put((byte)b);
        }

        @Override
        public void write(byte[] b) {
            QpidByteBuffer.this._buffer.put(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            QpidByteBuffer.this._buffer.put(b, off, len);
        }

        @Override
        public void writeBoolean(boolean v) {
            QpidByteBuffer.this._buffer.put(v ? (byte)1 : 0);
        }

        @Override
        public void writeByte(int v) {
            QpidByteBuffer.this._buffer.put((byte)v);
        }

        @Override
        public void writeShort(int v) {
            QpidByteBuffer.this._buffer.putShort((short)v);
        }

        @Override
        public void writeChar(int v) {
            QpidByteBuffer.this._buffer.put((byte)(v >>> 8));
            QpidByteBuffer.this._buffer.put((byte)v);
        }

        @Override
        public void writeInt(int v) {
            QpidByteBuffer.this._buffer.putInt(v);
        }

        @Override
        public void writeLong(long v) {
            QpidByteBuffer.this._buffer.putLong(v);
        }

        @Override
        public void writeFloat(float v) {
            this.writeInt(Float.floatToIntBits(v));
        }

        @Override
        public void writeDouble(double v) {
            this.writeLong(Double.doubleToLongBits(v));
        }

        @Override
        public void writeBytes(String s) {
            throw new UnsupportedOperationException("writeBytes(String s) not supported");
        }

        @Override
        public void writeChars(String s) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char v = s.charAt(i);
                QpidByteBuffer.this._buffer.put((byte)(v >>> 8));
                QpidByteBuffer.this._buffer.put((byte)v);
            }
        }

        @Override
        public void writeUTF(String s) {
            int strlen = s.length();
            int pos = QpidByteBuffer.this._buffer.position();
            QpidByteBuffer.this._buffer.position(pos + 2);
            for (int i = 0; i < strlen; ++i) {
                char c = s.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    c = s.charAt(i);
                    QpidByteBuffer.this._buffer.put((byte)c);
                    continue;
                }
                if (c > '\u07ff') {
                    QpidByteBuffer.this._buffer.put((byte)(0xE0 | c >> 12 & 0xF));
                    QpidByteBuffer.this._buffer.put((byte)(0x80 | c >> 6 & 0x3F));
                    QpidByteBuffer.this._buffer.put((byte)(0x80 | c & 0x3F));
                    continue;
                }
                QpidByteBuffer.this._buffer.put((byte)(0xC0 | c >> 6 & 0x1F));
                QpidByteBuffer.this._buffer.put((byte)(0x80 | c & 0x3F));
            }
            int len = QpidByteBuffer.this._buffer.position() - (pos + 2);
            QpidByteBuffer.this._buffer.put(pos++, (byte)(len >>> 8));
            QpidByteBuffer.this._buffer.put(pos, (byte)len);
        }
    }

    private final class BufferDataInput
    implements MarkableDataInput {
        private int _mark;
        private final int _offset;

        public BufferDataInput() {
            this._offset = QpidByteBuffer.this._buffer.position();
        }

        @Override
        public void readFully(byte[] b) {
            QpidByteBuffer.this._buffer.get(b);
        }

        @Override
        public void readFully(byte[] b, int off, int len) {
            QpidByteBuffer.this._buffer.get(b, 0, len);
        }

        @Override
        public QpidByteBuffer readAsByteBuffer(int len) {
            QpidByteBuffer view = QpidByteBuffer.this.view(0, len);
            this.skipBytes(len);
            return view;
        }

        @Override
        public int skipBytes(int n) {
            QpidByteBuffer.this._buffer.position(QpidByteBuffer.this._buffer.position() + n);
            return QpidByteBuffer.this._buffer.position() - this._offset;
        }

        @Override
        public boolean readBoolean() {
            return QpidByteBuffer.this._buffer.get() != 0;
        }

        @Override
        public byte readByte() {
            return QpidByteBuffer.this._buffer.get();
        }

        @Override
        public int readUnsignedByte() {
            return QpidByteBuffer.this._buffer.get() & 0xFF;
        }

        @Override
        public short readShort() {
            return QpidByteBuffer.this._buffer.getShort();
        }

        @Override
        public int readUnsignedShort() {
            return QpidByteBuffer.this._buffer.getShort() & 0xFFFF;
        }

        @Override
        public char readChar() {
            return QpidByteBuffer.this._buffer.getChar();
        }

        @Override
        public int readInt() {
            return QpidByteBuffer.this._buffer.getInt();
        }

        @Override
        public long readLong() {
            return QpidByteBuffer.this._buffer.getLong();
        }

        @Override
        public float readFloat() {
            return QpidByteBuffer.this._buffer.getFloat();
        }

        @Override
        public double readDouble() {
            return QpidByteBuffer.this._buffer.getDouble();
        }

        @Override
        public AMQShortString readAMQShortString() {
            return AMQShortString.readAMQShortString(QpidByteBuffer.this._buffer);
        }

        @Override
        public String readLine() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int available() {
            return QpidByteBuffer.this._buffer.remaining();
        }

        @Override
        public long skip(long i) {
            QpidByteBuffer.this._buffer.position(QpidByteBuffer.this._buffer.position() + (int)i);
            return i;
        }

        @Override
        public int read(byte[] b) {
            this.readFully(b);
            return b.length;
        }

        public int position() {
            return QpidByteBuffer.this._buffer.position() - this._offset;
        }

        public void position(int position) {
            QpidByteBuffer.this._buffer.position(position + this._offset);
        }

        public int length() {
            return QpidByteBuffer.this._buffer.limit();
        }

        @Override
        public void mark(int readAhead) {
            this._mark = this.position();
        }

        @Override
        public void reset() {
            this.position(this._mark);
        }
    }

    private final class BufferInputStream
    extends InputStream {
        private BufferInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (QpidByteBuffer.this._buffer.hasRemaining()) {
                return QpidByteBuffer.this._buffer.get() & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (!QpidByteBuffer.this._buffer.hasRemaining()) {
                return -1;
            }
            if (QpidByteBuffer.this._buffer.remaining() < len) {
                len = QpidByteBuffer.this._buffer.remaining();
            }
            QpidByteBuffer.this._buffer.get(b, off, len);
            return len;
        }

        @Override
        public void mark(int readlimit) {
            QpidByteBuffer.this._buffer.mark();
        }

        @Override
        public void reset() throws IOException {
            QpidByteBuffer.this._buffer.reset();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public long skip(long n) throws IOException {
            QpidByteBuffer.this._buffer.position(QpidByteBuffer.this._buffer.position() + (int)n);
            return n;
        }

        @Override
        public int available() throws IOException {
            return QpidByteBuffer.this._buffer.remaining();
        }

        @Override
        public void close() {
        }
    }
}

