/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.codec;

import java.io.IOException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.HeartbeatBody;
import org.apache.qpid.framing.MethodProcessor;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.protocol.AMQConstant;

public abstract class AMQDecoder<T extends MethodProcessor> {
    private static final int MAX_BUFFERS_LIMIT = 10;
    private final T _methodProcessor;
    private ProtocolInitiation.Decoder _piDecoder = new ProtocolInitiation.Decoder();
    private boolean _expectProtocolInitiation;
    private boolean _firstRead = true;
    private int _maxFrameSize = AMQConstant.FRAME_MIN_SIZE.getCode();

    protected AMQDecoder(boolean expectProtocolInitiation, T methodProcessor) {
        this._expectProtocolInitiation = expectProtocolInitiation;
        this._methodProcessor = methodProcessor;
    }

    public void setExpectProtocolInitiation(boolean expectProtocolInitiation) {
        this._expectProtocolInitiation = expectProtocolInitiation;
    }

    public void setMaxFrameSize(int frameMax) {
        this._maxFrameSize = frameMax;
    }

    public T getMethodProcessor() {
        return this._methodProcessor;
    }

    protected void decode(MarkableDataInput msg) throws IOException, AMQFrameDecodingException {
        if (this._firstRead && msg.available() > 0) {
            msg.mark(1);
            this._firstRead = false;
            if (!this._expectProtocolInitiation && (msg.readByte() & 0xFF) > 8) {
                this._expectProtocolInitiation = true;
            }
            msg.reset();
        }
        boolean enoughData = true;
        while (enoughData) {
            if (!this._expectProtocolInitiation) {
                enoughData = this.decodable(msg);
                if (!enoughData) continue;
                this.processInput(msg);
                continue;
            }
            enoughData = this._piDecoder.decodable(msg);
            if (!enoughData) continue;
            this._methodProcessor.receiveProtocolHeader(new ProtocolInitiation(msg));
        }
    }

    private boolean decodable(MarkableDataInput in) throws AMQFrameDecodingException, IOException {
        int remainingAfterAttributes = in.available() - 8;
        if (remainingAfterAttributes < 0) {
            return false;
        }
        in.mark(8);
        in.skip(3L);
        long bodySize = (long)in.readInt() & 0xFFFFFFFFL;
        if (bodySize > (long)this._maxFrameSize) {
            throw new AMQFrameDecodingException(AMQConstant.FRAME_ERROR, "Incoming frame size of " + bodySize + " is larger than negotiated maximum of  " + this._maxFrameSize);
        }
        in.reset();
        return (long)remainingAfterAttributes >= bodySize;
    }

    private void processInput(MarkableDataInput in) throws AMQFrameDecodingException, AMQProtocolVersionException, IOException {
        byte type = in.readByte();
        int channel = in.readUnsignedShort();
        long bodySize = EncodingUtils.readUnsignedInteger(in);
        if (channel < 0 || bodySize < 0L) {
            throw new AMQFrameDecodingException(AMQConstant.FRAME_ERROR, "Undecodable frame: type = " + type + " channel = " + channel + " bodySize = " + bodySize);
        }
        this.processFrame(channel, type, bodySize, in);
        byte marker = in.readByte();
        if ((marker & 0xFF) != 206) {
            throw new AMQFrameDecodingException(AMQConstant.FRAME_ERROR, "End of frame marker not found. Read " + marker + " length=" + bodySize + " type=" + type);
        }
    }

    protected void processFrame(int channel, byte type, long bodySize, MarkableDataInput in) throws AMQFrameDecodingException, IOException {
        switch (type) {
            case 1: {
                this.processMethod(channel, in);
                break;
            }
            case 2: {
                ContentHeaderBody.process(in, this._methodProcessor.getChannelMethodProcessor(channel), bodySize);
                break;
            }
            case 3: {
                ContentBody.process(in, this._methodProcessor.getChannelMethodProcessor(channel), bodySize);
                break;
            }
            case 8: {
                HeartbeatBody.process(channel, in, this._methodProcessor, bodySize);
                break;
            }
            default: {
                throw new AMQFrameDecodingException(AMQConstant.FRAME_ERROR, "Unsupported frame type: " + type);
            }
        }
    }

    abstract void processMethod(int var1, MarkableDataInput var2) throws AMQFrameDecodingException, IOException;

    AMQFrameDecodingException newUnknownMethodException(int classId, int methodId, ProtocolVersion protocolVersion) {
        return new AMQFrameDecodingException(AMQConstant.COMMAND_INVALID, "Method " + methodId + " unknown in AMQP version " + protocolVersion + " (while trying to decode class " + classId + " method " + methodId + ".");
    }
}

