/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;

public class BasicConsumeOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 21;
    private final AMQShortString _consumerTag;

    public BasicConsumeOkBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._consumerTag = buffer.readAMQShortString();
    }

    public BasicConsumeOkBody(AMQShortString consumerTag) {
        this._consumerTag = consumerTag;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 21;
    }

    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._consumerTag);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._consumerTag);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicConsumeOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicConsumeOkBodyImpl: ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ClientChannelMethodProcessor dispatcher) throws IOException {
        AMQShortString consumerTag = buffer.readAMQShortString();
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicConsumeOk(consumerTag);
        }
    }
}

