/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;

public class BasicGetEmptyBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 72;
    private final AMQShortString _clusterId;

    public BasicGetEmptyBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._clusterId = buffer.readAMQShortString();
    }

    public BasicGetEmptyBody(AMQShortString clusterId) {
        this._clusterId = clusterId;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 72;
    }

    public final AMQShortString getClusterId() {
        return this._clusterId;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._clusterId);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._clusterId);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicGetEmpty(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicGetEmptyBody: ");
        buf.append("clusterId=");
        buf.append(this.getClusterId());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ClientChannelMethodProcessor dispatcher) throws IOException {
        AMQShortString clusterId = buffer.readAMQShortString();
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicGetEmpty();
        }
    }
}

