/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.MethodDispatcher;

public class BasicGetOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 71;
    private final long _deliveryTag;
    private final byte _bitfield0;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final long _messageCount;

    public BasicGetOkBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._deliveryTag = buffer.readLong();
        this._bitfield0 = buffer.readByte();
        this._exchange = buffer.readAMQShortString();
        this._routingKey = buffer.readAMQShortString();
        this._messageCount = EncodingUtils.readUnsignedInteger(buffer);
    }

    public BasicGetOkBody(long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey, long messageCount) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (redelivered) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._messageCount = messageCount;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 71;
    }

    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    public final boolean getRedelivered() {
        return (this._bitfield0 & 1) != 0;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public final long getMessageCount() {
        return this._messageCount;
    }

    @Override
    protected int getBodySize() {
        int size = 13;
        size += this.getSizeOf(this._exchange);
        return size += this.getSizeOf(this._routingKey);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeUnsignedInteger(buffer, this._messageCount);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicGetOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicGetOkBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("redelivered=");
        buf.append(this.getRedelivered());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("messageCount=");
        buf.append(this.getMessageCount());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ClientChannelMethodProcessor dispatcher) throws IOException {
        long deliveryTag = buffer.readLong();
        boolean redelivered = (buffer.readByte() & 1) != 0;
        AMQShortString exchange = buffer.readAMQShortString();
        AMQShortString routingKey = buffer.readAMQShortString();
        long messageCount = EncodingUtils.readUnsignedInteger(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicGetOk(deliveryTag, redelivered, exchange, routingKey, messageCount);
        }
    }
}

