/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;

public class BasicRejectBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 90;
    private final long _deliveryTag;
    private final byte _bitfield0;

    public BasicRejectBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._deliveryTag = buffer.readLong();
        this._bitfield0 = buffer.readByte();
    }

    public BasicRejectBody(long deliveryTag, boolean requeue) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (requeue) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 90;
    }

    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    public final boolean getRequeue() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 9;
        return size;
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicReject(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicRejectBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("requeue=");
        buf.append(this.getRequeue());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ServerChannelMethodProcessor dispatcher) throws IOException {
        boolean requeue;
        long deliveryTag = buffer.readLong();
        boolean bl = requeue = (buffer.readByte() & 1) != 0;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicReject(deliveryTag, requeue);
        }
    }
}

