/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQShortString;

public class ByteBufferDataInput
implements MarkableDataInput {
    private final ByteBuffer _underlying;
    private int _mark;
    private final int _offset;

    public ByteBufferDataInput(ByteBuffer underlying) {
        this._underlying = underlying;
        this._offset = underlying.position();
    }

    @Override
    public void readFully(byte[] b) {
        this._underlying.get(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        this._underlying.get(b, 0, len);
    }

    @Override
    public QpidByteBuffer readAsByteBuffer(int len) {
        ByteBuffer buf = this._underlying.slice();
        buf.limit(len);
        this.skipBytes(len);
        return QpidByteBuffer.wrap(buf);
    }

    @Override
    public int skipBytes(int n) {
        this._underlying.position(this._underlying.position() + n);
        return this._underlying.position() - this._offset;
    }

    @Override
    public boolean readBoolean() {
        return this._underlying.get() != 0;
    }

    @Override
    public byte readByte() {
        return this._underlying.get();
    }

    @Override
    public int readUnsignedByte() {
        return this._underlying.get() & 0xFF;
    }

    @Override
    public short readShort() {
        return this._underlying.getShort();
    }

    @Override
    public int readUnsignedShort() {
        return this._underlying.getShort() & 0xFFFF;
    }

    @Override
    public char readChar() {
        return this._underlying.getChar();
    }

    @Override
    public int readInt() {
        return this._underlying.getInt();
    }

    @Override
    public long readLong() {
        return this._underlying.getLong();
    }

    @Override
    public float readFloat() {
        return this._underlying.getFloat();
    }

    @Override
    public double readDouble() {
        return this._underlying.getDouble();
    }

    @Override
    public AMQShortString readAMQShortString() {
        return AMQShortString.readAMQShortString(this._underlying);
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() {
        return this._underlying.remaining();
    }

    @Override
    public long skip(long i) {
        this._underlying.position(this._underlying.position() + (int)i);
        return i;
    }

    @Override
    public int read(byte[] b) {
        this.readFully(b);
        return b.length;
    }

    public int position() {
        return this._underlying.position() - this._offset;
    }

    public void position(int position) {
        this._underlying.position(position + this._offset);
    }

    public int length() {
        return this._underlying.limit();
    }

    @Override
    public void mark(int readAhead) {
        this._mark = this.position();
    }

    @Override
    public void reset() {
        this._underlying.position(this._mark);
    }
}

