/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;

public class ChannelAlertBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 30;
    private final int _replyCode;
    private final AMQShortString _replyText;
    private final FieldTable _details;

    public ChannelAlertBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._replyCode = buffer.readUnsignedShort();
        this._replyText = buffer.readAMQShortString();
        this._details = EncodingUtils.readFieldTable(buffer);
    }

    public ChannelAlertBody(int replyCode, AMQShortString replyText, FieldTable details) {
        this._replyCode = replyCode;
        this._replyText = replyText;
        this._details = details;
    }

    @Override
    public int getClazz() {
        return 20;
    }

    @Override
    public int getMethod() {
        return 30;
    }

    public final int getReplyCode() {
        return this._replyCode;
    }

    public final AMQShortString getReplyText() {
        return this._replyText;
    }

    public final FieldTable getDetails() {
        return this._details;
    }

    @Override
    protected int getBodySize() {
        int size = 2;
        size += this.getSizeOf(this._replyText);
        return size += this.getSizeOf(this._details);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._replyCode);
        this.writeAMQShortString(buffer, this._replyText);
        this.writeFieldTable(buffer, this._details);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchChannelAlert(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ChannelAlertBodyImpl: ");
        buf.append("replyCode=");
        buf.append(this.getReplyCode());
        buf.append(", ");
        buf.append("replyText=");
        buf.append(this.getReplyText());
        buf.append(", ");
        buf.append("details=");
        buf.append(this.getDetails());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ClientChannelMethodProcessor dispatcher) throws IOException, AMQFrameDecodingException {
        int replyCode = buffer.readUnsignedShort();
        AMQShortString replyText = buffer.readAMQShortString();
        FieldTable details = EncodingUtils.readFieldTable(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveChannelAlert(replyCode, replyText, details);
        }
        if (details != null) {
            details.clearEncodedForm();
        }
    }
}

