/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.MethodProcessor;
import org.apache.qpid.framing.ProtocolVersion;

public class ConnectionCloseBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 10;
    private final int _ownMethodId;
    private final int _replyCode;
    private final AMQShortString _replyText;
    private final int _classId;
    private final int _methodId;

    public ConnectionCloseBody(MarkableDataInput buffer, ProtocolVersion protocolVersion) throws AMQFrameDecodingException, IOException {
        this._ownMethodId = ProtocolVersion.v0_8.equals(protocolVersion) ? 60 : 50;
        this._replyCode = buffer.readUnsignedShort();
        this._replyText = buffer.readAMQShortString();
        this._classId = buffer.readUnsignedShort();
        this._methodId = buffer.readUnsignedShort();
    }

    public ConnectionCloseBody(ProtocolVersion protocolVersion, int replyCode, AMQShortString replyText, int classId, int methodId) {
        this._ownMethodId = ProtocolVersion.v0_8.equals(protocolVersion) ? 60 : 50;
        this._replyCode = replyCode;
        this._replyText = replyText;
        this._classId = classId;
        this._methodId = methodId;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return this._ownMethodId;
    }

    public final int getReplyCode() {
        return this._replyCode;
    }

    public final AMQShortString getReplyText() {
        return this._replyText;
    }

    public final int getClassId() {
        return this._classId;
    }

    public final int getMethodId() {
        return this._methodId;
    }

    @Override
    protected int getBodySize() {
        int size = 6;
        return size += this.getSizeOf(this._replyText);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._replyCode);
        this.writeAMQShortString(buffer, this._replyText);
        this.writeUnsignedShort(buffer, this._classId);
        this.writeUnsignedShort(buffer, this._methodId);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionClose(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionCloseBodyImpl: ");
        buf.append("replyCode=");
        buf.append(this.getReplyCode());
        buf.append(", ");
        buf.append("replyText=");
        buf.append(this.getReplyText());
        buf.append(", ");
        buf.append("classId=");
        buf.append(this.getClassId());
        buf.append(", ");
        buf.append("methodId=");
        buf.append(this.getMethodId());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, MethodProcessor dispatcher) throws IOException {
        int replyCode = buffer.readUnsignedShort();
        AMQShortString replyText = buffer.readAMQShortString();
        int classId = buffer.readUnsignedShort();
        int methodId = buffer.readUnsignedShort();
        dispatcher.receiveConnectionClose(replyCode, replyText, classId, methodId);
    }
}

