/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerMethodProcessor;

public class ConnectionSecureOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 21;
    private final byte[] _response;

    public ConnectionSecureOkBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._response = EncodingUtils.readBytes(buffer);
    }

    public ConnectionSecureOkBody(byte[] response) {
        this._response = response;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 21;
    }

    public final byte[] getResponse() {
        return this._response;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._response);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeBytes(buffer, this._response);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionSecureOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionSecureOkBodyImpl: ");
        buf.append("response=");
        buf.append(this.getResponse() == null ? "null" : Arrays.toString(this.getResponse()));
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput in, ServerMethodProcessor dispatcher) throws IOException {
        byte[] response = EncodingUtils.readBytes(in);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveConnectionSecureOk(response);
        }
    }
}

