/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ClientChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;

public class ExchangeBoundOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 40;
    public static final int METHOD_ID = 23;
    public static final int OK = 0;
    public static final int EXCHANGE_NOT_FOUND = 1;
    public static final int QUEUE_NOT_FOUND = 2;
    public static final int NO_BINDINGS = 3;
    public static final int QUEUE_NOT_BOUND = 4;
    public static final int NO_QUEUE_BOUND_WITH_RK = 5;
    public static final int SPECIFIC_QUEUE_NOT_BOUND_WITH_RK = 6;
    private final int _replyCode;
    private final AMQShortString _replyText;

    public ExchangeBoundOkBody(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._replyCode = buffer.readUnsignedShort();
        this._replyText = buffer.readAMQShortString();
    }

    public ExchangeBoundOkBody(int replyCode, AMQShortString replyText) {
        this._replyCode = replyCode;
        this._replyText = replyText;
    }

    @Override
    public int getClazz() {
        return 40;
    }

    @Override
    public int getMethod() {
        return 23;
    }

    public final int getReplyCode() {
        return this._replyCode;
    }

    public final AMQShortString getReplyText() {
        return this._replyText;
    }

    @Override
    protected int getBodySize() {
        int size = 2;
        return size += this.getSizeOf(this._replyText);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._replyCode);
        this.writeAMQShortString(buffer, this._replyText);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchExchangeBoundOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ExchangeBoundOkBodyImpl: ");
        buf.append("replyCode=");
        buf.append(this.getReplyCode());
        buf.append(", ");
        buf.append("replyText=");
        buf.append(this.getReplyText());
        buf.append("]");
        return buf.toString();
    }

    public static void process(MarkableDataInput buffer, ClientChannelMethodProcessor dispatcher) throws IOException {
        int replyCode = buffer.readUnsignedShort();
        AMQShortString replyText = buffer.readAMQShortString();
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveExchangeBoundOk(replyCode, replyText);
        }
    }
}

