/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.util.Map;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.AccessRequestBody;
import org.apache.qpid.framing.AccessRequestOkBody;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicConsumeBody;
import org.apache.qpid.framing.BasicConsumeOkBody;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.BasicGetBody;
import org.apache.qpid.framing.BasicGetEmptyBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicQosOkBody;
import org.apache.qpid.framing.BasicRecoverBody;
import org.apache.qpid.framing.BasicRecoverSyncBody;
import org.apache.qpid.framing.BasicRecoverSyncOkBody;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ChannelAlertBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ChannelFlowBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.ConnectionOpenOkBody;
import org.apache.qpid.framing.ConnectionRedirectBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionSecureOkBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.ConnectionTuneOkBody;
import org.apache.qpid.framing.ExchangeBoundBody;
import org.apache.qpid.framing.ExchangeBoundOkBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.ExchangeDeclareOkBody;
import org.apache.qpid.framing.ExchangeDeleteBody;
import org.apache.qpid.framing.ExchangeDeleteOkBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueBindOkBody;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.framing.QueueDeleteBody;
import org.apache.qpid.framing.QueueDeleteOkBody;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.QueuePurgeOkBody;
import org.apache.qpid.framing.QueueUnbindBody;
import org.apache.qpid.framing.QueueUnbindOkBody;
import org.apache.qpid.framing.TxCommitBody;
import org.apache.qpid.framing.TxCommitOkBody;
import org.apache.qpid.framing.TxRollbackBody;
import org.apache.qpid.framing.TxRollbackOkBody;
import org.apache.qpid.framing.TxSelectBody;
import org.apache.qpid.framing.TxSelectOkBody;

public final class MethodRegistry {
    private ProtocolVersion _protocolVersion;

    public MethodRegistry(ProtocolVersion pv) {
        this._protocolVersion = pv;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    public final AccessRequestBody createAccessRequestBody(AMQShortString realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
        return new AccessRequestBody(realm, exclusive, passive, active, write, read);
    }

    public final AccessRequestOkBody createAccessRequestOkBody(int ticket) {
        return new AccessRequestOkBody(ticket);
    }

    public final BasicQosBody createBasicQosBody(long prefetchSize, int prefetchCount, boolean global) {
        return new BasicQosBody(prefetchSize, prefetchCount, global);
    }

    public final BasicQosOkBody createBasicQosOkBody() {
        return new BasicQosOkBody();
    }

    public final BasicConsumeBody createBasicConsumeBody(int ticket, String queue, String consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, Map<String, Object> arguments) {
        return new BasicConsumeBody(ticket, AMQShortString.valueOf(queue), AMQShortString.valueOf(consumerTag), noLocal, noAck, exclusive, nowait, FieldTable.convertToFieldTable(arguments));
    }

    public final BasicConsumeOkBody createBasicConsumeOkBody(AMQShortString consumerTag) {
        return new BasicConsumeOkBody(consumerTag);
    }

    public final BasicCancelBody createBasicCancelBody(AMQShortString consumerTag, boolean nowait) {
        return new BasicCancelBody(consumerTag, nowait);
    }

    public final BasicCancelOkBody createBasicCancelOkBody(AMQShortString consumerTag) {
        return new BasicCancelOkBody(consumerTag);
    }

    public final BasicPublishBody createBasicPublishBody(int ticket, String exchange, String routingKey, boolean mandatory, boolean immediate) {
        return new BasicPublishBody(ticket, AMQShortString.valueOf(exchange), AMQShortString.valueOf(routingKey), mandatory, immediate);
    }

    public final BasicReturnBody createBasicReturnBody(int replyCode, AMQShortString replyText, AMQShortString exchange, AMQShortString routingKey) {
        return new BasicReturnBody(replyCode, replyText, exchange, routingKey);
    }

    public final BasicDeliverBody createBasicDeliverBody(AMQShortString consumerTag, long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey) {
        return new BasicDeliverBody(consumerTag, deliveryTag, redelivered, exchange, routingKey);
    }

    public final BasicGetBody createBasicGetBody(int ticket, AMQShortString queue, boolean noAck) {
        return new BasicGetBody(ticket, queue, noAck);
    }

    public final BasicGetOkBody createBasicGetOkBody(long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey, long messageCount) {
        return new BasicGetOkBody(deliveryTag, redelivered, exchange, routingKey, messageCount);
    }

    public final BasicGetEmptyBody createBasicGetEmptyBody(AMQShortString clusterId) {
        return new BasicGetEmptyBody(clusterId);
    }

    public final BasicAckBody createBasicAckBody(long deliveryTag, boolean multiple) {
        return new BasicAckBody(deliveryTag, multiple);
    }

    public final BasicRejectBody createBasicRejectBody(long deliveryTag, boolean requeue) {
        return new BasicRejectBody(deliveryTag, requeue);
    }

    public final BasicRecoverBody createBasicRecoverBody(boolean requeue) {
        return new BasicRecoverBody(requeue);
    }

    public final BasicRecoverSyncOkBody createBasicRecoverSyncOkBody() {
        return new BasicRecoverSyncOkBody(this._protocolVersion);
    }

    public final BasicRecoverSyncBody createBasicRecoverSyncBody(boolean requeue) {
        return new BasicRecoverSyncBody(this._protocolVersion, requeue);
    }

    public final ChannelAlertBody createChannelAlertBody(int replyCode, AMQShortString replyText, FieldTable details) {
        return new ChannelAlertBody(replyCode, replyText, details);
    }

    public final ChannelOpenBody createChannelOpenBody(AMQShortString outOfBand) {
        return new ChannelOpenBody();
    }

    public final ChannelOpenOkBody createChannelOpenOkBody(byte[] channelId) {
        return this.createChannelOpenOkBody();
    }

    public final ChannelOpenOkBody createChannelOpenOkBody() {
        return this._protocolVersion.equals(ProtocolVersion.v0_8) ? ChannelOpenOkBody.INSTANCE_0_8 : ChannelOpenOkBody.INSTANCE_0_9;
    }

    public final ChannelFlowBody createChannelFlowBody(boolean active) {
        return new ChannelFlowBody(active);
    }

    public final ChannelFlowOkBody createChannelFlowOkBody(boolean active) {
        return new ChannelFlowOkBody(active);
    }

    public final ChannelCloseBody createChannelCloseBody(int replyCode, AMQShortString replyText, int classId, int methodId) {
        return new ChannelCloseBody(replyCode, replyText, classId, methodId);
    }

    public final ChannelCloseOkBody createChannelCloseOkBody() {
        return ChannelCloseOkBody.INSTANCE;
    }

    public final ConnectionStartBody createConnectionStartBody(short versionMajor, short versionMinor, FieldTable serverProperties, byte[] mechanisms, byte[] locales) {
        return new ConnectionStartBody(versionMajor, versionMinor, serverProperties, mechanisms, locales);
    }

    public final ConnectionStartOkBody createConnectionStartOkBody(FieldTable clientProperties, AMQShortString mechanism, byte[] response, AMQShortString locale) {
        return new ConnectionStartOkBody(clientProperties, mechanism, response, locale);
    }

    public final ConnectionSecureBody createConnectionSecureBody(byte[] challenge) {
        return new ConnectionSecureBody(challenge);
    }

    public final ConnectionSecureOkBody createConnectionSecureOkBody(byte[] response) {
        return new ConnectionSecureOkBody(response);
    }

    public final ConnectionTuneBody createConnectionTuneBody(int channelMax, long frameMax, int heartbeat) {
        return new ConnectionTuneBody(channelMax, frameMax, heartbeat);
    }

    public final ConnectionTuneOkBody createConnectionTuneOkBody(int channelMax, long frameMax, int heartbeat) {
        return new ConnectionTuneOkBody(channelMax, frameMax, heartbeat);
    }

    public final ConnectionOpenBody createConnectionOpenBody(AMQShortString virtualHost, AMQShortString capabilities, boolean insist) {
        return new ConnectionOpenBody(virtualHost, capabilities, insist);
    }

    public final ConnectionOpenOkBody createConnectionOpenOkBody(AMQShortString knownHosts) {
        return new ConnectionOpenOkBody(knownHosts);
    }

    public final ConnectionRedirectBody createConnectionRedirectBody(AMQShortString host, AMQShortString knownHosts) {
        return new ConnectionRedirectBody(this._protocolVersion, host, knownHosts);
    }

    public final ConnectionCloseBody createConnectionCloseBody(int replyCode, AMQShortString replyText, int classId, int methodId) {
        return new ConnectionCloseBody(this._protocolVersion, replyCode, replyText, classId, methodId);
    }

    public final ConnectionCloseOkBody createConnectionCloseOkBody() {
        return ProtocolVersion.v0_8.equals(this._protocolVersion) ? ConnectionCloseOkBody.CONNECTION_CLOSE_OK_0_8 : ConnectionCloseOkBody.CONNECTION_CLOSE_OK_0_9;
    }

    public final ExchangeDeclareBody createExchangeDeclareBody(int ticket, String exchange, String type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, Map<String, Object> arguments) {
        return new ExchangeDeclareBody(ticket, AMQShortString.valueOf(exchange), AMQShortString.valueOf(type), passive, durable, autoDelete, internal, nowait, FieldTable.convertToFieldTable(arguments));
    }

    public final ExchangeDeclareOkBody createExchangeDeclareOkBody() {
        return new ExchangeDeclareOkBody();
    }

    public final ExchangeDeleteBody createExchangeDeleteBody(int ticket, String exchange, boolean ifUnused, boolean nowait) {
        return new ExchangeDeleteBody(ticket, AMQShortString.valueOf(exchange), ifUnused, nowait);
    }

    public final ExchangeDeleteOkBody createExchangeDeleteOkBody() {
        return new ExchangeDeleteOkBody();
    }

    public final ExchangeBoundBody createExchangeBoundBody(String exchange, String routingKey, String queue) {
        return new ExchangeBoundBody(AMQShortString.valueOf(exchange), AMQShortString.valueOf(routingKey), AMQShortString.valueOf(queue));
    }

    public final ExchangeBoundOkBody createExchangeBoundOkBody(int replyCode, AMQShortString replyText) {
        return new ExchangeBoundOkBody(replyCode, replyText);
    }

    public final QueueDeclareBody createQueueDeclareBody(int ticket, String queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, Map<String, Object> arguments) {
        return new QueueDeclareBody(ticket, AMQShortString.valueOf(queue), passive, durable, exclusive, autoDelete, nowait, FieldTable.convertToFieldTable(arguments));
    }

    public final QueueDeclareOkBody createQueueDeclareOkBody(AMQShortString queue, long messageCount, long consumerCount) {
        return new QueueDeclareOkBody(queue, messageCount, consumerCount);
    }

    public final QueueBindBody createQueueBindBody(int ticket, String queue, String exchange, String routingKey, boolean nowait, Map<String, Object> arguments) {
        return new QueueBindBody(ticket, AMQShortString.valueOf(queue), AMQShortString.valueOf(exchange), AMQShortString.valueOf(routingKey), nowait, FieldTable.convertToFieldTable(arguments));
    }

    public final QueueBindOkBody createQueueBindOkBody() {
        return new QueueBindOkBody();
    }

    public final QueuePurgeBody createQueuePurgeBody(int ticket, AMQShortString queue, boolean nowait) {
        return new QueuePurgeBody(ticket, queue, nowait);
    }

    public final QueuePurgeOkBody createQueuePurgeOkBody(long messageCount) {
        return new QueuePurgeOkBody(messageCount);
    }

    public final QueueDeleteBody createQueueDeleteBody(int ticket, String queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
        return new QueueDeleteBody(ticket, AMQShortString.valueOf(queue), ifUnused, ifEmpty, nowait);
    }

    public final QueueDeleteOkBody createQueueDeleteOkBody(long messageCount) {
        return new QueueDeleteOkBody(messageCount);
    }

    public final QueueUnbindBody createQueueUnbindBody(int ticket, AMQShortString queue, AMQShortString exchange, AMQShortString routingKey, FieldTable arguments) {
        return new QueueUnbindBody(ticket, queue, exchange, routingKey, arguments);
    }

    public final QueueUnbindOkBody createQueueUnbindOkBody() {
        return new QueueUnbindOkBody();
    }

    public final TxSelectBody createTxSelectBody() {
        return TxSelectBody.INSTANCE;
    }

    public final TxSelectOkBody createTxSelectOkBody() {
        return TxSelectOkBody.INSTANCE;
    }

    public final TxCommitBody createTxCommitBody() {
        return TxCommitBody.INSTANCE;
    }

    public final TxCommitOkBody createTxCommitOkBody() {
        return TxCommitOkBody.INSTANCE;
    }

    public final TxRollbackBody createTxRollbackBody() {
        return TxRollbackBody.INSTANCE;
    }

    public final TxRollbackOkBody createTxRollbackOkBody() {
        return TxRollbackOkBody.INSTANCE;
    }

    public ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }
}

