/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.qpid.jms.provider.amqp.message.AmqpObjectTypeDelegate;
import org.apache.qpid.jms.util.ClassLoadingAwareObjectInputStream;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class AmqpSerializedObjectDelegate
implements AmqpObjectTypeDelegate {
    static final Data NULL_OBJECT_BODY;
    private final Message message;

    public AmqpSerializedObjectDelegate(Message message) {
        this.message = message;
        this.message.setContentType("application/x-java-serialized-object");
    }

    /*
     * Exception decompiling
     */
    private static byte[] getSerializedBytes(Serializable value) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Serializable getObject() throws IOException, ClassNotFoundException {
        Binary bin = null;
        Section body = this.message.getBody();
        if (body == null || body == NULL_OBJECT_BODY) {
            return null;
        }
        if (!(body instanceof Data)) {
            throw new IllegalStateException("Unexpected body type: " + body.getClass().getSimpleName());
        }
        bin = ((Data)body).getValue();
        if (bin == null) {
            return null;
        }
        Serializable serialized = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bin.getArray(), bin.getArrayOffset(), bin.getLength());
             ClassLoadingAwareObjectInputStream objIn = new ClassLoadingAwareObjectInputStream(bais);){
            serialized = (Serializable)objIn.readObject();
        }
        return serialized;
    }

    @Override
    public void setObject(Serializable value) throws IOException {
        if (value == null) {
            this.message.setBody((Section)NULL_OBJECT_BODY);
        } else {
            byte[] bytes = AmqpSerializedObjectDelegate.getSerializedBytes(value);
            this.message.setBody((Section)new Data(new Binary(bytes)));
        }
    }

    @Override
    public void onSend() {
        this.message.setContentType("application/x-java-serialized-object");
        if (this.message.getBody() == null) {
            this.message.setBody((Section)NULL_OBJECT_BODY);
        }
    }

    @Override
    public boolean isAmqpTypeEncoded() {
        return false;
    }

    static {
        byte[] bytes;
        try {
            bytes = AmqpSerializedObjectDelegate.getSerializedBytes(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialise null object body", e);
        }
        NULL_OBJECT_BODY = new Data(new Binary(bytes));
    }
}

