/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.provider.ProviderConstants;

public final class JmsAcknowledgeCallback {
    private final JmsSession session;
    private int ackType;

    public JmsAcknowledgeCallback(JmsSession session) {
        this.session = session;
    }

    public void acknowledge() throws JMSException {
        if (this.session.isClosed()) {
            throw new IllegalStateException("Session closed.");
        }
        this.session.acknowledge(this.lookupAckTypeForDisposition(this.getAckType()));
    }

    private ProviderConstants.ACK_TYPE lookupAckTypeForDisposition(int dispositionType) throws JMSException {
        switch (dispositionType) {
            case 1: {
                return ProviderConstants.ACK_TYPE.ACCEPTED;
            }
            case 2: {
                return ProviderConstants.ACK_TYPE.REJECTED;
            }
            case 3: {
                return ProviderConstants.ACK_TYPE.RELEASED;
            }
            case 4: {
                return ProviderConstants.ACK_TYPE.MODIFIED_FAILED;
            }
            case 5: {
                return ProviderConstants.ACK_TYPE.MODIFIED_FAILED_UNDELIVERABLE;
            }
        }
        throw new JMSException("Unable to determine ack type for disposition: " + dispositionType);
    }

    public boolean isAckTypeSet() {
        return this.ackType > 0;
    }

    public void clearAckType() {
        this.ackType = 0;
    }

    public int getAckType() {
        return this.ackType <= 0 ? 1 : this.ackType;
    }

    public void setAckType(int ackType) {
        this.ackType = ackType;
    }
}

