/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.management.common;

import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.SSLException;
import javax.security.sasl.SaslClientFactory;
import org.apache.qpid.management.common.sasl.CRAMMD5HashedSaslClientFactory;
import org.apache.qpid.management.common.sasl.JCAProvider;
import org.apache.qpid.management.common.sasl.SaslProvider;
import org.apache.qpid.management.common.sasl.UserPasswordCallbackHandler;
import org.apache.qpid.management.common.sasl.UsernameHashedPasswordCallbackHandler;

public class JMXConnnectionFactory {
    private static final String NON_JRMP_SERVER = "non-JRMP server at remote endpoint";
    private static final String SERVER_SUPPORTED_PROFILES = "The server supported profiles";
    private static final String CLIENT_REQUIRED_PROFILES = "do not match the client required profiles";

    public static JMXConnector getJMXConnection(long timeout, String host, int port, String username, String password) throws SSLException, IOException, Exception {
        try {
            return JMXConnnectionFactory.createJMXconnector("RMI", timeout, host, port, username, password);
        }
        catch (IOException rmiIOE) {
            boolean jrmpServer;
            boolean bl = jrmpServer = !rmiIOE.getMessage().contains(NON_JRMP_SERVER);
            if (jrmpServer) {
                Throwable rmiIOECause = rmiIOE.getCause();
                boolean isSSLException = false;
                if (rmiIOECause != null) {
                    isSSLException = rmiIOECause instanceof SSLException;
                }
                if (isSSLException) {
                    throw (SSLException)rmiIOECause;
                }
                IOException nioe = new IOException();
                nioe.initCause(rmiIOE);
                throw nioe;
            }
            try {
                return JMXConnnectionFactory.createJMXconnector("JMXMP_CRAM-MD5", timeout, host, port, username, password);
            }
            catch (IOException cramIOE) {
                boolean plainProfileServer = cramIOE.getMessage().contains("The server supported profiles [SASL/PLAIN] do not match the client required profiles [SASL/CRAM-MD5]");
                if (!plainProfileServer) {
                    IOException nioe = new IOException();
                    nioe.initCause(cramIOE);
                    throw nioe;
                }
                try {
                    return JMXConnnectionFactory.createJMXconnector("JMXMP_PLAIN", timeout, host, port, username, password);
                }
                catch (IOException plainIOE) {
                    boolean unknownProfile = plainIOE.getMessage().contains("do not match the client required profiles [SASL/PLAIN]");
                    if (unknownProfile) {
                        throw new Exception("Unknown JMXMP authentication mechanism, unable to connect.");
                    }
                    IOException nioe = new IOException();
                    nioe.initCause(plainIOE);
                    throw nioe;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JMXConnector createJMXconnector(String connectionType, long timeout, String host, int port, String userName, String password) throws IOException, Exception {
        HashMap<String, Object> env = new HashMap<String, Object>();
        JMXServiceURL jmxUrl = null;
        if (connectionType.equalsIgnoreCase("RMI")) {
            jmxUrl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/jmxrmi");
            env.put("jmx.remote.credentials", new String[]{userName, password});
        } else {
            if (!connectionType.contains("JMXMP")) throw new Exception("Unknown connection type");
            String jmxmpcClass = "javax.management.remote.jmxmp.JMXMPConnector";
            try {
                Class.forName("javax.management.remote.jmxmp.JMXMPConnector");
            }
            catch (ClassNotFoundException cnfe) {
                throw new Exception("JMXMPConnector class not found, unable to connect to specified server.\n\nPlease add the jmxremote_optional.jar to the jmxremote.sasl plugin folder, or the classpath.");
            }
            jmxUrl = new JMXServiceURL("jmxmp", host, port);
            env = new HashMap();
            env.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
            if (connectionType.equalsIgnoreCase("JMXMP_CRAM-MD5")) {
                HashMap<String, Class<? extends SaslClientFactory>> map = new HashMap<String, Class<? extends SaslClientFactory>>();
                map.put("CRAM-MD5-HASHED", CRAMMD5HashedSaslClientFactory.class);
                Security.addProvider(new JCAProvider((Map<String, Class<? extends SaslClientFactory>>)map));
                UsernameHashedPasswordCallbackHandler handler = new UsernameHashedPasswordCallbackHandler(userName, password);
                env.put("jmx.remote.profiles", "SASL/CRAM-MD5");
                env.put("jmx.remote.sasl.callback.handler", handler);
            } else {
                if (!connectionType.equalsIgnoreCase("JMXMP_PLAIN")) throw new Exception("Unknown JMXMP authentication mechanism");
                Security.addProvider(new SaslProvider());
                UserPasswordCallbackHandler handler = new UserPasswordCallbackHandler(userName, password);
                env.put("jmx.remote.profiles", "SASL/PLAIN");
                env.put("jmx.remote.sasl.callback.handler", handler);
            }
        }
        ConnectWaiter connector = new ConnectWaiter(jmxUrl, env);
        Thread connectorThread = new Thread(connector);
        connectorThread.start();
        connectorThread.join(timeout);
        if (connector.getJmxc() != null) return connector.getJmxc();
        if (connector.getConnectionException() == null) throw new IOException("Timed out connecting to " + host + ":" + port);
        throw connector.getConnectionException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectWaiter
    implements Runnable {
        private Exception _connectionException;
        private JMXConnector _jmxc;
        private JMXServiceURL _jmxUrl;
        private Map<String, ?> _env;
        private boolean _connectionRetrieved;

        public ConnectWaiter(JMXServiceURL url, Map<String, ?> env) {
            this._jmxUrl = url;
            this._env = env;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ConnectWaiter connectWaiter = this;
                synchronized (connectWaiter) {
                    if (this._connectionRetrieved) {
                        this._jmxc = null;
                        this._connectionRetrieved = false;
                        this._connectionException = null;
                    }
                }
                JMXConnector conn = JMXConnectorFactory.connect(this._jmxUrl, this._env);
                ConnectWaiter connectWaiter2 = this;
                synchronized (connectWaiter2) {
                    if (this._connectionRetrieved) {
                        try {
                            conn.close();
                        }
                        catch (IOException iOException) {}
                    } else {
                        this._jmxc = conn;
                    }
                }
            }
            catch (Exception ex) {
                this._connectionException = ex;
            }
        }

        public Exception getConnectionException() {
            return this._connectionException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JMXConnector getJmxc() {
            ConnectWaiter connectWaiter = this;
            synchronized (connectWaiter) {
                this._connectionRetrieved = true;
                return this._jmxc;
            }
        }
    }
}

