/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.management.common.mbeans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.management.JMException;
import javax.management.openmbean.TabularData;
import org.apache.qpid.management.common.mbeans.annotations.MBeanAttribute;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperation;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperationParameter;

public interface ManagedConnection {
    public static final String TYPE = "Connection";
    public static final String CHAN_ID = "Channel Id";
    public static final String TRANSACTIONAL = "Transactional";
    public static final String DEFAULT_QUEUE = "Default Queue";
    public static final String UNACKED_COUNT = "Unacknowledged Message Count";
    public static final String FLOW_BLOCKED = "Flow Blocked";
    public static final List<String> COMPOSITE_ITEM_NAMES_DESC = Collections.unmodifiableList(Arrays.asList("Channel Id", "Transactional", "Default Queue", "Unacknowledged Message Count", "Flow Blocked"));
    public static final List<String> TABULAR_UNIQUE_INDEX = Collections.unmodifiableList(Arrays.asList("Channel Id"));

    @MBeanAttribute(name="ClientId", description="Client Id")
    public String getClientId();

    @MBeanAttribute(name="AuthorizedId", description="User Name")
    public String getAuthorizedId();

    @MBeanAttribute(name="Version", description="Client Version")
    public String getVersion();

    @MBeanAttribute(name="RemoteAddress", description="Connection Address")
    public String getRemoteAddress();

    @MBeanAttribute(name="LastIOTime", description="The last time, the IO operation was done")
    public Date getLastIoTime();

    @MBeanAttribute(name="MaximumNumberOfChannels", description="The threshold high value for number of channels for this connection")
    public Long getMaximumNumberOfChannels();

    @MBeanOperation(name="channels", description="Channel details for this connection")
    public TabularData channels() throws IOException, JMException;

    @MBeanOperation(name="commitTransaction", description="Commits the transactions for given channel Id, if the channel is transactional", impact=1)
    public void commitTransactions(@MBeanOperationParameter(name="channel Id", description="channel Id") int var1) throws JMException;

    @MBeanOperation(name="rollbackTransactions", description="Rollsback the transactions for given channel Id, if the channel is transactional", impact=1)
    public void rollbackTransactions(@MBeanOperationParameter(name="channel Id", description="channel Id") int var1) throws JMException;

    @MBeanOperation(name="closeConnection", description="Closes this connection and all related channels", impact=1)
    public void closeConnection() throws Exception;

    @MBeanOperation(name="resetStatistics", description="Resets message and data statistics for this connection", impact=1)
    public void resetStatistics() throws Exception;

    @MBeanAttribute(name="PeakMessageDeliveryRate", description="Connection Peak Message Delivery Rate")
    public double getPeakMessageDeliveryRate();

    @MBeanAttribute(name="PeakDataDeliveryRate", description="Connection Peak Data Delivery Rate")
    public double getPeakDataDeliveryRate();

    @MBeanAttribute(name="MessageDeliveryRate", description="Connection Message Delivery Rate")
    public double getMessageDeliveryRate();

    @MBeanAttribute(name="DataDeliveryRate", description="Connection Data Delivery Rate")
    public double getDataDeliveryRate();

    @MBeanAttribute(name="TotalMessagesDelivered", description="Connection Total Messages Delivered")
    public long getTotalMessagesDelivered();

    @MBeanAttribute(name="TotalDataDelivered", description="Connection Total Data Delivered")
    public long getTotalDataDelivered();

    @MBeanAttribute(name="PeakMessageReceiptRate", description="Connection Peak Message Receipt Rate")
    public double getPeakMessageReceiptRate();

    @MBeanAttribute(name="PeakDataReceiptRate", description="Connection Peak Data Receipt Rate")
    public double getPeakDataReceiptRate();

    @MBeanAttribute(name="MessageReceiptRate", description="Connection Message Receipt Rate")
    public double getMessageReceiptRate();

    @MBeanAttribute(name="DataReceiptRate", description="Connection Data Receipt Rate")
    public double getDataReceiptRate();

    @MBeanAttribute(name="TotalMessagesReceived", description="Connection Total Messages Received")
    public long getTotalMessagesReceived();

    @MBeanAttribute(name="TotalDataReceived", description="Connection Total Data Received")
    public long getTotalDataReceived();

    @MBeanAttribute(name="StatisticsEnabled", description="Connection Statistics Enabled")
    public boolean isStatisticsEnabled();

    public void setStatisticsEnabled(boolean var1);
}

