/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.management.common.mbeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.management.JMException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.qpid.management.common.mbeans.annotations.MBeanAttribute;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperation;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperationParameter;

public interface ManagedQueue {
    public static final String TYPE = "Queue";
    public static final String MSG_AMQ_ID = "AMQ MessageId";
    public static final String MSG_HEADER = "Header";
    public static final String MSG_SIZE = "Size(bytes)";
    public static final String MSG_REDELIVERED = "Redelivered";
    public static final String MSG_QUEUE_POS = "Queue Position";
    public static final String MSG_DELIVERY_COUNT = "Delivery Count";
    public static final List<String> VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC = Collections.unmodifiableList(Arrays.asList("AMQ MessageId", "Header", "Size(bytes)", "Redelivered", "Queue Position", "Delivery Count"));
    public static final List<String> VIEW_MSGS_TABULAR_UNIQUE_INDEX = Collections.unmodifiableList(Arrays.asList("Queue Position"));
    public static final String MIME = "MimeType";
    public static final String ENCODING = "Encoding";
    public static final String CONTENT = "Content";
    public static final List<String> VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC = Collections.unmodifiableList(Arrays.asList("AMQ MessageId", "MimeType", "Encoding", "Content"));
    public static final String JMSTIMESTAMP_DATETIME_FORMAT = "MM-dd-yy HH:mm:ss.SSS z";
    public static final String ATTR_NAME = "Name";
    public static final String ATTR_DESCRIPTION = "Description";
    public static final String ATTR_QUEUE_TYPE = "QueueType";
    public static final String ATTR_OWNER = "Owner";
    public static final String ATTR_MAX_MSG_AGE = "MaximumMessageAge";
    public static final String ATTR_MAX_MSG_COUNT = "MaximumMessageCount";
    public static final String ATTR_MAX_QUEUE_DEPTH = "MaximumQueueDepth";
    public static final String ATTR_MAX_MSG_SIZE = "MaximumMessageSize";
    public static final String ATTR_MAXIMUM_DELIVERY_COUNT = "MaximumDeliveryCount";
    public static final String ATTR_DURABLE = "Durable";
    public static final String ATTR_AUTODELETE = "AutoDelete";
    public static final String ATTR_CONSUMER_COUNT = "ConsumerCount";
    public static final String ATTR_ACTIVE_CONSUMER_COUNT = "ActiveConsumerCount";
    public static final String ATTR_MSG_COUNT = "MessageCount";
    public static final String ATTR_QUEUE_DEPTH = "QueueDepth";
    public static final String ATTR_RCVD_MSG_COUNT = "ReceivedMessageCount";
    public static final String ATTR_CAPACITY = "Capacity";
    public static final String ATTR_FLOW_OVERFULL = "FlowOverfull";
    public static final String ATTR_FLOW_RESUME_CAPACITY = "FlowResumeCapacity";
    public static final String ATTR_EXCLUSIVE = "Exclusive";
    public static final String ATTR_ALT_EXCHANGE = "AlternateExchange";
    public static final List<String> QUEUE_ATTRIBUTES = Collections.unmodifiableList(new ArrayList<String>(new HashSet<String>(Arrays.asList("Name", "QueueType", "Description", "Owner", "MaximumMessageAge", "MaximumMessageCount", "MaximumQueueDepth", "MaximumMessageSize", "MaximumDeliveryCount", "Durable", "AutoDelete", "ConsumerCount", "ActiveConsumerCount", "MessageCount", "QueueDepth", "ReceivedMessageCount", "Capacity", "FlowOverfull", "FlowResumeCapacity", "Exclusive", "AlternateExchange"))));

    @MBeanAttribute(name="Name", description="Queue Name")
    public String getName() throws IOException;

    @MBeanAttribute(name="MessageCount", description="Total number of undelivered messages on the queue")
    public Integer getMessageCount() throws IOException;

    @MBeanAttribute(name="MaximumDeliveryCount", description="Maximum number of times a message is permitted to be delivered or zero if not enforced")
    public Integer getMaximumDeliveryCount() throws IOException;

    @MBeanAttribute(name="ReceivedMessageCount", description="The total number of messages receieved by the queue since startup")
    public Long getReceivedMessageCount() throws IOException;

    @MBeanAttribute(name="QueueDepth", description="The total size(Bytes) of messages in the queue")
    public Long getQueueDepth() throws IOException, JMException;

    @MBeanAttribute(name="ActiveConsumerCount", description="The total number of active subscribers to the queue")
    public Integer getActiveConsumerCount() throws IOException;

    @MBeanAttribute(name="ConsumerCount", description="The total number of subscribers to the queue")
    public Integer getConsumerCount() throws IOException;

    @MBeanAttribute(name="Owner", description="Owner")
    public String getOwner() throws IOException;

    @MBeanAttribute(name="Durable", description="true if the AMQQueue is durable")
    public boolean isDurable() throws IOException;

    @MBeanAttribute(name="AutoDelete", description="true if the AMQQueue is AutoDelete")
    public boolean isAutoDelete() throws IOException;

    public Long getMaximumMessageAge() throws IOException;

    @MBeanAttribute(name="MaximumMessageAge", description="Threshold high value(milliseconds) for message age")
    public void setMaximumMessageAge(Long var1) throws IOException;

    public Long getMaximumMessageSize() throws IOException;

    @MBeanAttribute(name="MaximumMessageSize", description="Threshold high value(Bytes) for a message size")
    public void setMaximumMessageSize(Long var1) throws IOException;

    public Long getMaximumMessageCount() throws IOException;

    @MBeanAttribute(name="MaximumMessageCount", description="Threshold high value for number of undelivered messages in the queue")
    public void setMaximumMessageCount(Long var1) throws IOException;

    public Long getMaximumQueueDepth() throws IOException;

    @MBeanAttribute(name="MaximumQueueDepth", description="The threshold high value(Bytes) for Queue Depth")
    public void setMaximumQueueDepth(Long var1) throws IOException;

    public Long getCapacity() throws IOException;

    @MBeanAttribute(name="Capacity", description="The flow control Capacity (Bytes) of the queue")
    public void setCapacity(Long var1) throws IOException, IllegalArgumentException;

    public String getDescription();

    @MBeanAttribute(name="Description", description="Free text description of the queue")
    public void setDescription(String var1);

    @MBeanAttribute(name="QueueType", description="Type of the queue e.g. standard, priority, etc")
    public String getQueueType();

    public Long getFlowResumeCapacity() throws IOException;

    @MBeanAttribute(name="FlowResumeCapacity", description="The flow resume Capacity (Bytes) of the queue")
    public void setFlowResumeCapacity(Long var1) throws IOException, IllegalArgumentException;

    @MBeanAttribute(name="FlowOverfull", description="true if the queue is considered overfull by the Flow Control system")
    public boolean isFlowOverfull() throws IOException;

    public boolean isExclusive() throws IOException;

    @MBeanAttribute(name="Exclusive", description="Whether the queue is Exclusive or not")
    public void setExclusive(boolean var1) throws IOException, JMException;

    @MBeanAttribute(name="AlternateExchange", description="Alternate exchange for the queue")
    public void setAlternateExchange(String var1) throws IOException, JMException;

    public String getAlternateExchange() throws IOException;

    @Deprecated
    @MBeanOperation(name="viewMessages", description="Message headers for messages in this queue within given index range. eg. from index 1 - 100")
    public TabularData viewMessages(@MBeanOperationParameter(name="from index", description="from index") int var1, @MBeanOperationParameter(name="to index", description="to index") int var2) throws IOException, JMException;

    @MBeanOperation(name="viewMessages", description="Message headers for messages in this queue within given queue positions range. eg. from index 1 - 100")
    public TabularData viewMessages(@MBeanOperationParameter(name="start position", description="start position") long var1, @MBeanOperationParameter(name="end position", description="end position") long var3) throws IOException, JMException;

    @MBeanOperation(name="viewMessageContent", description="The message content for given Message Id")
    public CompositeData viewMessageContent(@MBeanOperationParameter(name="Message Id", description="Message Id") long var1) throws IOException, JMException;

    @Deprecated
    @MBeanOperation(name="deleteMessageFromTop", description="Deletes the first message from top", impact=1)
    public void deleteMessageFromTop() throws IOException, JMException;

    @MBeanOperation(name="clearQueue", description="Clears the queue by deleting all the messages from the queue that have not been acquired by consumers", impact=1)
    public Long clearQueue() throws IOException, JMException;

    @MBeanOperation(name="moveMessages", description="You can move messages to another queue from this queue ", impact=1)
    public void moveMessages(@MBeanOperationParameter(name="from MessageId", description="from MessageId") long var1, @MBeanOperationParameter(name="to MessageId", description="to MessageId") long var3, @MBeanOperationParameter(name="Queue", description="to Queue Name") String var5) throws IOException, JMException;

    @MBeanOperation(name="deleteMessages", description="Delete a range of messages from a specified queue", impact=1)
    public void deleteMessages(@MBeanOperationParameter(name="from MessageId", description="from MessageId") long var1, @MBeanOperationParameter(name="to MessageId", description="to MessageId") long var3) throws IOException, JMException;

    @MBeanOperation(name="copyMessages", description="Copies a range of messages to a specified queue", impact=1)
    public void copyMessages(@MBeanOperationParameter(name="from MessageId", description="from MessageId") long var1, @MBeanOperationParameter(name="to MessageId", description="to MessageId") long var3, @MBeanOperationParameter(name="Queue", description="to Queue Name") String var5) throws IOException, JMException;
}

