/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.management.common.sasl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class UsernameHashedPasswordCallbackHandler
implements CallbackHandler {
    private String user;
    private char[] pwchars;

    public UsernameHashedPasswordCallbackHandler(String user, String password) throws Exception {
        this.user = user;
        this.pwchars = UsernameHashedPasswordCallbackHandler.getHash(password);
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback ncb = (NameCallback)callbacks[i];
                ncb.setName(this.user);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pcb = (PasswordCallback)callbacks[i];
                pcb.setPassword(this.pwchars);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    private void clearPassword() {
        if (this.pwchars != null) {
            for (int i = 0; i < this.pwchars.length; ++i) {
                this.pwchars[i] = '\u0000';
            }
            this.pwchars = null;
        }
    }

    protected void finalize() {
        this.clearPassword();
    }

    public static char[] getHash(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] data = text.getBytes("utf-8");
        MessageDigest md = MessageDigest.getInstance("MD5");
        for (byte b : data) {
            md.update(b);
        }
        byte[] digest = md.digest();
        char[] hash = new char[digest.length];
        int index = 0;
        for (byte b : digest) {
            hash[index++] = (char)b;
        }
        return hash;
    }
}

