/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.Wss10;

public class Wss11
extends Wss10 {
    private boolean MustSupportRefThumbprint;
    private boolean MustSupportRefEncryptedKey;
    private boolean RequireSignatureConfirmation;

    public Wss11(int version) {
        super(version);
    }

    public boolean isMustSupportRefEncryptedKey() {
        return this.MustSupportRefEncryptedKey;
    }

    public void setMustSupportRefEncryptedKey(boolean mustSupportRefEncryptedKey) {
        this.MustSupportRefEncryptedKey = mustSupportRefEncryptedKey;
    }

    public boolean isMustSupportRefThumbprint() {
        return this.MustSupportRefThumbprint;
    }

    public void setMustSupportRefThumbprint(boolean mustSupportRefThumbprint) {
        this.MustSupportRefThumbprint = mustSupportRefThumbprint;
    }

    public boolean isRequireSignatureConfirmation() {
        return this.RequireSignatureConfirmation;
    }

    public void setRequireSignatureConfirmation(boolean requireSignatureConfirmation) {
        this.RequireSignatureConfirmation = requireSignatureConfirmation;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.WSS11;
        }
        return SP11Constants.WSS11;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            writer.setPrefix(SPConstants.POLICY.getPrefix(), SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(prefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.isMustSupportRefKeyIdentifier()) {
            writer.writeStartElement(prefix, "MustSupportRefKeyIdentifier", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefIssuerSerial()) {
            writer.writeStartElement(prefix, "MustSupportRefIssuerSerial", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefExternalURI()) {
            writer.writeStartElement(prefix, "MustSupportRefExternalURI", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefEmbeddedToken()) {
            writer.writeStartElement(prefix, "MustSupportRefEmbeddedToken", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefThumbprint()) {
            writer.writeStartElement(prefix, "MustSupportRefThumbprint", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefEncryptedKey()) {
            writer.writeStartElement(prefix, "MustSupportRefEncryptedkey", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireSignatureConfirmation()) {
            writer.writeStartElement(prefix, "RequireSignatureConfirmation", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

