/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy11.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.SignedEncryptedElements;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;

public class SupportingTokensBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        QName name = element.getQName();
        SupportingToken supportingToken = null;
        if (SP11Constants.SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(1, 1);
        } else if (SP11Constants.SIGNED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(3, 1);
        } else if (SP11Constants.ENDORSING_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(2, 1);
        } else if (SP11Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(4, 1);
        }
        Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement());
        policy = (Policy)policy.normalize(false);
        Iterator iterator = policy.getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), supportingToken);
        }
        return supportingToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SUPPORTING_TOKENS, SP11Constants.SIGNED_SUPPORTING_TOKENS, SP11Constants.ENDORSING_SUPPORTING_TOKENS, SP11Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS};
    }

    private void processAlternative(List assertions, SupportingToken supportingToken) {
        for (Assertion primitive : assertions) {
            QName qname = primitive.getName();
            if (SP11Constants.ALGORITHM_SUITE.equals(qname)) {
                supportingToken.setAlgorithmSuite((AlgorithmSuite)primitive);
                continue;
            }
            if (SP11Constants.SIGNED_PARTS.equals(qname)) {
                supportingToken.setSignedParts((SignedEncryptedParts)primitive);
                continue;
            }
            if (SP11Constants.SIGNED_ELEMENTS.equals(qname)) {
                supportingToken.setSignedElements((SignedEncryptedElements)primitive);
                continue;
            }
            if (SP11Constants.ENCRYPTED_PARTS.equals(qname)) {
                supportingToken.setEncryptedParts((SignedEncryptedParts)primitive);
                continue;
            }
            if (SP11Constants.ENCRYPTED_ELEMENTS.equals(qname)) {
                supportingToken.setEncryptedElements((SignedEncryptedElements)primitive);
                continue;
            }
            if (!(primitive instanceof Token)) continue;
            supportingToken.addToken((Token)primitive);
        }
    }
}

