/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy11.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.model.X509Token;

public class X509TokenBuilder
implements AssertionBuilder {
    public static final String USER_CERT_ALIAS_LN = "userCertAlias";
    public static final String ENCRYPTION_USER_LN = "encryptionUser";
    public static final QName RAMPART_CONFIG = new QName("http://ws.apache.org/rampart/policy", "RampartConfig");
    public static final QName USER_CERT_ALIAS = new QName("http://ws.apache.org/rampart/policy", "userCertAlias");
    public static final QName ENCRYPTION_USER = new QName("http://ws.apache.org/rampart/policy", "encryptionUser");

    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        OMAttribute isOptional;
        X509Token x509Token = new X509Token(1);
        OMElement policyElement = element.getFirstElement();
        OMAttribute includeAttr = element.getAttribute(SP11Constants.INCLUDE_TOKEN);
        if (includeAttr != null) {
            int inclusion = SP11Constants.getInclusionFromAttributeValue(includeAttr.getAttributeValue());
            x509Token.setInclusion(inclusion);
        }
        if ((isOptional = element.getAttribute(Constants.Q_ELEM_OPTIONAL_ATTR)) != null) {
            x509Token.setOptional(new Boolean(isOptional.getAttributeValue()));
        }
        if (policyElement != null) {
            if (policyElement.getFirstChildWithName(SP11Constants.REQUIRE_DERIVED_KEYS) != null) {
                x509Token.setDerivedKeys(true);
            }
            Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement());
            Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
            if (iterator.hasNext()) {
                this.processAlternative((List)iterator.next(), x509Token);
            }
        }
        if (x509Token != null && policyElement != null) {
            OMElement ramp = null;
            ramp = policyElement.getFirstChildWithName(RAMPART_CONFIG);
            if (ramp != null) {
                OMElement child = null;
                child = ramp.getFirstChildWithName(USER_CERT_ALIAS);
                if (child != null) {
                    x509Token.setUserCertAlias(child.getText());
                }
                if ((child = ramp.getFirstChildWithName(ENCRYPTION_USER)) != null) {
                    x509Token.setEncryptionUser(child.getText());
                }
            }
        }
        return x509Token;
    }

    private void processAlternative(List assertions, X509Token parent) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (SP11Constants.REQUIRE_KEY_IDENTIFIRE_REFERENCE.equals(name)) {
                parent.setRequireKeyIdentifierReference(true);
                continue;
            }
            if (SP11Constants.REQUIRE_ISSUER_SERIAL_REFERENCE.equals(name)) {
                parent.setRequireIssuerSerialReference(true);
                continue;
            }
            if (SP11Constants.REQUIRE_EMBEDDED_TOKEN_REFERENCE.equals(name)) {
                parent.setRequireEmbeddedTokenReference(true);
                continue;
            }
            if (SP11Constants.REQUIRE_THUMBPRINT_REFERENCE.equals(name)) {
                parent.setRequireThumbprintReference(true);
                continue;
            }
            if (SP11Constants.WSS_X509_V1_TOKEN_10.equals(name)) {
                parent.setTokenVersionAndType("WssX509V1Token10");
                continue;
            }
            if (SP11Constants.WSS_X509_V1_TOKEN_11.equals(name)) {
                parent.setTokenVersionAndType("WssX509V1Token11");
                continue;
            }
            if (SP11Constants.WSS_X509_V3_TOKEN_10.equals(name)) {
                parent.setTokenVersionAndType("WssX509V3Token10");
                continue;
            }
            if (SP11Constants.WSS_X509_V3_TOKEN_11.equals(name)) {
                parent.setTokenVersionAndType("WssX509V3Token11");
                continue;
            }
            if (SP11Constants.WSS_X509_PKCS7_TOKEN_10.equals(name)) {
                parent.setTokenVersionAndType("WssX509Pkcs7Token10");
                continue;
            }
            if (SP11Constants.WSS_X509_PKCS7_TOKEN_11.equals(name)) {
                parent.setTokenVersionAndType("WssX509Pkcs7Token11");
                continue;
            }
            if (SP11Constants.WSS_X509_PKI_PATH_V1_TOKEN_10.equals(name)) {
                parent.setTokenVersionAndType("WssX509PkiPathV1Token10");
                continue;
            }
            if (!SP11Constants.WSS_X509_PKI_PATH_V1_TOKEN_11.equals(name)) continue;
            parent.setTokenVersionAndType("WssX509PkiPathV1Token11");
        }
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.X509_TOKEN};
    }
}

