/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class RecipientToken
extends AbstractSecurityAssertion
implements TokenWrapper {
    private Token receipientToken;

    public RecipientToken(int version) {
        this.setVersion(version);
    }

    public Token getReceipientToken() {
        return this.receipientToken;
    }

    public void setReceipientToken(Token receipientToken) {
        this.receipientToken = receipientToken;
    }

    @Override
    public void setToken(Token tok) {
        this.setReceipientToken(tok);
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.RECIPIENT_TOKEN;
        }
        return SP11Constants.RECIPIENT_TOKEN;
    }

    @Override
    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        Token token = this.getReceipientToken();
        if (token == null) {
            throw new RuntimeException("RecipientToken doesn't contain any token assertions");
        }
        token.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

