/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.Token;

public class UsernameToken
extends Token {
    private boolean useUTProfile10 = false;
    private boolean useUTProfile11 = false;
    private boolean noPassword;
    private boolean hashPassword;

    public UsernameToken(int version) {
        this.setVersion(version);
    }

    public boolean isUseUTProfile11() {
        return this.useUTProfile11;
    }

    public void setUseUTProfile11(boolean useUTProfile11) {
        this.useUTProfile11 = useUTProfile11;
    }

    public boolean isNoPassword() {
        return this.noPassword;
    }

    public void setNoPassword(boolean noPassword) {
        this.noPassword = noPassword;
    }

    public boolean isHashPassword() {
        return this.hashPassword;
    }

    public void setHashPassword(boolean hashPassword) {
        this.hashPassword = hashPassword;
    }

    public boolean isUseUTProfile10() {
        return this.useUTProfile10;
    }

    public void setUseUTProfile10(boolean useUTProfile10) {
        this.useUTProfile10 = useUTProfile10;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.USERNAME_TOKEN;
        }
        return SP11Constants.USERNAME_TOKEN;
    }

    @Override
    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String inclusion = this.version == 2 ? SP12Constants.getAttributeValueFromInclusion(this.getInclusion()) : SP11Constants.getAttributeValueFromInclusion(this.getInclusion());
        if (inclusion != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.isUseUTProfile10() || this.isUseUTProfile11()) {
            String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
            if (pPrefix == null) {
                writer.setPrefix(SPConstants.POLICY.getPrefix(), SPConstants.POLICY.getNamespaceURI());
            }
            writer.writeStartElement(prefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
            if (this.isUseUTProfile10()) {
                writer.writeStartElement(prefix, "WssUsernameToken10", namespaceURI);
            } else {
                writer.writeStartElement(prefix, "WssUsernameToken11", namespaceURI);
            }
            if (this.version == 2) {
                if (this.isNoPassword()) {
                    writer.writeStartElement(prefix, "NoPassword", namespaceURI);
                    writer.writeEndElement();
                } else if (this.isHashPassword()) {
                    writer.writeStartElement(prefix, "HashPassword", namespaceURI);
                    writer.writeEndElement();
                }
                if (this.isDerivedKeys()) {
                    writer.writeStartElement(prefix, "RequireDerivedKeys", namespaceURI);
                    writer.writeEndElement();
                } else if (this.isExplicitDerivedKeys()) {
                    writer.writeStartElement(prefix, "RequireExplicitDerivedKeys", namespaceURI);
                    writer.writeEndElement();
                } else if (this.isImpliedDerivedKeys()) {
                    writer.writeStartElement(prefix, "RequireImpliedDerivedKeys", namespaceURI);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

