/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class TransportToken
extends AbstractSecurityAssertion
implements TokenWrapper {
    private Token transportToken;

    public TransportToken(int version) {
        this.setVersion(version);
    }

    public Token getTransportToken() {
        return this.transportToken;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.TRANSPORT_TOKEN;
        }
        return SP11Constants.TRANSPORT_TOKEN;
    }

    @Override
    public boolean isOptional() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getType() {
        return 5;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        String wspPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (wspPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(SPConstants.POLICY.getPrefix(), SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.transportToken != null) {
            this.transportToken.serialize(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    @Override
    public void setToken(Token tok) {
        this.transportToken = tok;
    }
}

