/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Header;

public class RequiredParts
extends AbstractSecurityAssertion {
    private ArrayList headers = new ArrayList();

    public RequiredParts(int version) {
        this.setVersion(version);
    }

    public ArrayList getHeaders() {
        return this.headers;
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public QName getName() {
        return SP12Constants.REQUIRED_PARTS;
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        for (Header header : this.headers) {
            writer.writeStartElement(prefix, "Header", namespaceURI);
            if (header.getName() != null) {
                writer.writeAttribute("Name", header.getName());
            }
            writer.writeAttribute("Namespace", header.getNamespace());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

