/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.Token;

public class IssuedToken
extends Token {
    private OMElement issuerEpr;
    private OMElement issuerMex;
    private OMElement rstTemplate;
    boolean requireExternalReference;
    boolean requireInternalReference;
    private String rstTokenType;
    private Set<String> rstClaimSet;

    public IssuedToken(int version) {
        this.setVersion(version);
    }

    public OMElement getIssuerEpr() {
        return this.issuerEpr;
    }

    public void setIssuerEpr(OMElement issuerEpr) {
        this.issuerEpr = issuerEpr;
    }

    public boolean isRequireExternalReference() {
        return this.requireExternalReference;
    }

    public void setRequireExternalReference(boolean requireExternalReference) {
        this.requireExternalReference = requireExternalReference;
    }

    public boolean isRequireInternalReference() {
        return this.requireInternalReference;
    }

    public void setRequireInternalReference(boolean requireInternalReference) {
        this.requireInternalReference = requireInternalReference;
    }

    public OMElement getRstTemplate() {
        return this.rstTemplate;
    }

    public void setRstTemplate(OMElement rstTemplate) {
        this.rstTemplate = rstTemplate;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.ISSUED_TOKEN;
        }
        return SP11Constants.ISSUED_TOKEN;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String inclusion;
        String prefix;
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((inclusion = this.version == 2 ? SP12Constants.getAttributeValueFromInclusion(this.getInclusion()) : SP11Constants.getAttributeValueFromInclusion(this.getInclusion())) != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.issuerEpr != null) {
            writer.writeStartElement(prefix, "Issuer", namespaceURI);
            this.issuerEpr.serialize(writer);
            writer.writeEndElement();
        }
        if (this.rstTemplate != null) {
            this.rstTemplate.serialize(writer);
        }
        String policyLocalName = SPConstants.POLICY.getLocalPart();
        String policyNamespaceURI = SPConstants.POLICY.getNamespaceURI();
        String wspWriterPrefix = writer.getPrefix(policyNamespaceURI);
        if (wspWriterPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, policyNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        if (this.isRequireExternalReference() || this.isRequireInternalReference() || this.isDerivedKeys()) {
            writer.writeStartElement(wspPrefix, policyLocalName, policyNamespaceURI);
            if (wspWriterPrefix == null) {
                writer.writeNamespace(wspPrefix, policyNamespaceURI);
            }
            if (this.isRequireExternalReference()) {
                writer.writeEmptyElement(prefix, "RequireExternalReference", namespaceURI);
            }
            if (this.isRequireInternalReference()) {
                writer.writeEmptyElement(prefix, "RequireInternalReference", namespaceURI);
            }
            if (this.isDerivedKeys()) {
                writer.writeEmptyElement(prefix, "RequireDerivedKeys", namespaceURI);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public OMElement getIssuerMex() {
        return this.issuerMex;
    }

    public void setIssuerMex(OMElement issuerMex) {
        this.issuerMex = issuerMex;
    }

    public String getRstTokenType() {
        return this.rstTokenType;
    }

    public void setRstTokenType(String rstTokenType) {
        this.rstTokenType = rstTokenType;
    }

    public Set<String> getRstClaimSet() {
        return this.rstClaimSet;
    }

    public void setRstClaimSet(Set<String> rstClaimSet) {
        this.rstClaimSet = rstClaimSet;
    }

    public String getRstNamespace() {
        if (this.rstTokenType.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0")) {
            return "urn:oasis:names:tc:SAML:2.0:assertion";
        }
        return "urn:oasis:names:tc:SAML:1.0:assertion";
    }
}

