/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.context.MessageContext;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.ws.security.KerberosTokenPrincipal;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.opensaml.SAMLAssertion;
import org.opensaml.saml2.core.Assertion;
import org.w3c.dom.Element;

public class RahasData {
    private MessageContext inMessageContext;
    private OMElement rstElement;
    private int version = -1;
    private String wstNs;
    private String requestType;
    private String tokenType;
    private String tokenId;
    private int keysize = -1;
    private String computedKeyAlgo;
    private String keyType;
    private String appliesToAddress;
    private OMElement appliesToEpr;
    private Principal principal;
    private X509Certificate clientCert;
    private byte[] ephmeralKey;
    private byte[] requestEntropy;
    private byte[] responseEntropy;
    private String addressingNs;
    private String soapNs;
    private OMElement claimElem;
    private String claimDialect;
    private SAMLAssertion assertion;
    private Assertion saml2Assertion;
    private String actAs;
    private String overridenSubjectValue;

    public RahasData(MessageContext inMessageContext) throws TrustException {
        this.inMessageContext = inMessageContext;
        this.processWSS4JSecurityResults();
        this.addressingNs = (String)this.inMessageContext.getProperty("WSAddressingVersion");
        this.rstElement = (OMElement)inMessageContext.getProperty("passiveSTSRST");
        if (this.rstElement == null) {
            this.rstElement = this.inMessageContext.getEnvelope().getBody().getFirstElement();
        }
        this.soapNs = this.inMessageContext.getEnvelope().getNamespace().getNamespaceURI();
        this.wstNs = this.rstElement.getNamespace().getNamespaceURI();
        int ver = TrustUtil.getWSTVersion(this.wstNs);
        if (ver == -1) {
            throw new TrustException("InvalidRequest");
        }
        this.version = ver;
        this.processRequestType();
        this.processTokenType();
        this.processKeyType();
        this.processKeySize();
        this.processAppliesTo();
        this.processEntropy();
        this.processClaims();
        this.processValidateTarget();
        this.processRenewTarget();
        this.processActAs();
    }

    private void processWSS4JSecurityResults() throws TrustException {
        Vector results = (Vector)this.inMessageContext.getProperty("RECV_RESULTS");
        if (results == null) {
            throw new TrustException("RequestFailed");
        }
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Object principalObject = wser.get((Object)"principal");
                int act = (Integer)wser.get((Object)"action");
                if (act == 2 && principalObject != null) {
                    this.clientCert = (X509Certificate)wser.get((Object)"x509-certificate");
                    this.principal = (Principal)principalObject;
                    continue;
                }
                if (act == 1 && principalObject != null) {
                    this.principal = (Principal)principalObject;
                    continue;
                }
                if (act == 4096) {
                    X509Certificate[] certificates = (X509Certificate[])wser.get((Object)"x509-certificates");
                    if (certificates == null || certificates.length <= 0) continue;
                    this.clientCert = certificates[0];
                    this.principal = this.clientCert.getSubjectDN();
                    continue;
                }
                if (act == 8) {
                    String samlVersion = (String)wser.get((Object)"samlVersion");
                    if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(samlVersion)) {
                        this.saml2Assertion = (Assertion)wser.get((Object)"saml-assertion");
                        continue;
                    }
                    this.assertion = (SAMLAssertion)wser.get((Object)"saml-assertion");
                    continue;
                }
                if (act != 4608 && act != 5120) continue;
                this.principal = (KerberosTokenPrincipal)principalObject;
            }
        }
        if (this.principal == null && (this.assertion == null || this.saml2Assertion == null)) {
            throw new TrustException("RequestFailed");
        }
    }

    private void processAppliesTo() throws TrustException {
        OMElement appliesToElem = this.rstElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "AppliesTo"));
        if (appliesToElem != null) {
            OMElement eprElem;
            this.appliesToEpr = eprElem = appliesToElem.getFirstElement();
            if (this.addressingNs == null) {
                this.addressingNs = eprElem.getNamespace().getNamespaceURI();
            }
            if (eprElem != null) {
                OMElement addrElem = eprElem.getFirstChildWithName(new QName(this.addressingNs, "Address"));
                if (addrElem != null && addrElem.getText() != null && !"".equals(addrElem.getText().trim())) {
                    this.appliesToAddress = addrElem.getText().trim();
                }
            } else {
                throw new TrustException("invalidAppliesToElem");
            }
        }
    }

    private void processRequestType() throws TrustException {
        OMElement reqTypeElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "RequestType"));
        if (reqTypeElem == null || reqTypeElem.getText() == null || reqTypeElem.getText().trim().length() == 0) {
            throw new TrustException("InvalidRequest");
        }
        this.requestType = reqTypeElem.getText().trim();
    }

    private void processTokenType() {
        OMElement tokTypeElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "TokenType"));
        if (tokTypeElem != null && tokTypeElem.getText() != null && !"".equals(tokTypeElem.getText().trim())) {
            this.tokenType = tokTypeElem.getText().trim();
        }
    }

    private void processKeyType() {
        String text;
        OMElement keyTypeElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "KeyType"));
        if (keyTypeElem != null && (text = keyTypeElem.getText()) != null && !"".equals(text.trim())) {
            this.keyType = text.trim();
        }
    }

    private void processKeySize() throws TrustException {
        String text;
        OMElement keySizeElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "KeySize"));
        if (keySizeElem != null && (text = keySizeElem.getText()) != null && !"".equals(text.trim())) {
            try {
                this.keysize = Integer.parseInt(text.trim());
                this.ephmeralKey = new byte[this.keysize / 8];
            }
            catch (NumberFormatException e) {
                throw new TrustException("InvalidRequest", new String[]{"invalid wst:Keysize value"}, e);
            }
        }
        this.keysize = -1;
    }

    private void processClaims() throws TrustException {
        this.claimElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "Claims"));
        if (this.claimElem != null) {
            this.claimDialect = this.claimElem.getAttributeValue(new QName(this.wstNs, "Dialect"));
        }
    }

    private void processValidateTarget() throws TrustException {
        OMElement validateTargetElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "ValidateTarget"));
        if (validateTargetElem != null) {
            OMElement strElem = validateTargetElem.getFirstChildWithName(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference"));
            Element elem = (Element)new StAXOMBuilder((OMFactory)new OMDOMFactory(), strElem.getXMLStreamReader()).getDocumentElement();
            try {
                SecurityTokenReference str = new SecurityTokenReference(elem);
                if (str.containsReference()) {
                    this.tokenId = str.getReference().getURI();
                } else if (str.containsKeyIdentifier()) {
                    this.tokenId = str.getKeyIdentifierValue();
                }
            }
            catch (WSSecurityException e) {
                throw new TrustException("errorExtractingTokenId", e);
            }
        }
    }

    private void processRenewTarget() throws TrustException {
        OMElement renewTargetElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "RenewTarget"));
        if (renewTargetElem != null) {
            OMElement strElem = renewTargetElem.getFirstChildWithName(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference"));
            Element elem = (Element)new StAXOMBuilder((OMFactory)new OMDOMFactory(), strElem.getXMLStreamReader()).getDocumentElement();
            try {
                SecurityTokenReference str = new SecurityTokenReference(elem);
                if (str.containsReference()) {
                    this.tokenId = str.getReference().getURI();
                } else if (str.containsKeyIdentifier()) {
                    this.tokenId = str.getKeyIdentifierValue();
                }
                if (this.tokenId == null && str.containsKeyIdentifier()) {
                    this.tokenId = str.getKeyIdentifierValue();
                }
            }
            catch (WSSecurityException e) {
                throw new TrustException("errorExtractingTokenId", e);
            }
        }
    }

    private void processEntropy() throws TrustException {
        OMElement entropyElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "Entropy"));
        if (entropyElem != null) {
            OMElement binSecElem = entropyElem.getFirstElement();
            if (binSecElem != null && binSecElem.getText() != null && !"".equals(binSecElem.getText())) {
                this.requestEntropy = Base64.decode((String)binSecElem.getText());
            } else {
                throw new TrustException("malformedEntropyElement", new String[]{entropyElem.toString()});
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processActAs() throws TrustException {
        if (this.version < 3) {
            return;
        }
        OMElement actAsElem = this.rstElement.getFirstChildWithName(new QName(this.wstNs, "ActAs", "wst"));
        String subject = null;
        if (actAsElem == null) {
            return;
        }
        OMElement samlAssertion = actAsElem.getFirstElement();
        String samlNamespace = samlAssertion.getNamespace().getNamespaceURI();
        if (samlNamespace.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
            OMElement stmtElem = samlAssertion.getFirstChildWithName(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement"));
            if (stmtElem == null) {
                stmtElem = samlAssertion.getFirstChildWithName(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement"));
            }
            OMElement subjectElem = null;
            if (stmtElem != null) {
                subjectElem = stmtElem.getFirstChildWithName(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Subject"));
            }
            OMElement nameIDElem = null;
            if (subjectElem != null) {
                nameIDElem = subjectElem.getFirstChildWithName(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier"));
            }
            if (nameIDElem != null) {
                subject = nameIDElem.getText();
            } else {
                OMElement attrStmt = samlAssertion.getFirstChildWithName(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement"));
                if (attrStmt == null) throw new TrustException("To process an ActAs element, either the NameID of the SAML subject or an attribute with the Name should be present.");
                Iterator attrItr = attrStmt.getChildrenWithName(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Attribute"));
                while (attrItr.hasNext()) {
                    OMElement attrElem = (OMElement)attrItr.next();
                    if (attrElem.getAttribute(new QName("Name")) == null || !attrElem.getAttribute(new QName("Name")).getAttributeValue().toUpperCase().equals("NAME")) continue;
                    OMElement attrValElem = attrElem.getFirstChildWithName(new QName("AttributeValue"));
                    if (attrValElem == null) throw new TrustException("Empty AttributeValue element in the SAML Assertion");
                    subject = attrValElem.getText();
                }
            }
        } else {
            if (!samlNamespace.equals("urn:oasis:names:tc:SAML:2.0:assertion")) throw new TrustException("Unsupported SAML version.");
            OMElement subjectElem = samlAssertion.getFirstChildWithName(new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Subject", "saml"));
            OMElement nameIDElem = null;
            if (subjectElem != null) {
                nameIDElem = subjectElem.getFirstChildWithName(new QName("urn:oasis:names:tc:SAML:2.0:assertion", "NameID", "saml"));
            }
            if (nameIDElem != null) {
                subject = nameIDElem.getText();
            } else {
                OMElement attrStmt = samlAssertion.getFirstChildWithName(new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeStatement", "saml"));
                if (attrStmt == null) throw new TrustException("To process an ActAs element, either the NameID of the SAML subject or an attribute with the Name should be present.");
                Iterator attrItr = attrStmt.getChildElements();
                while (attrItr.hasNext()) {
                    OMElement attrElem = (OMElement)attrItr.next();
                    if (attrElem.getAttribute(new QName("Name")) == null || !attrElem.getAttribute(new QName("Name")).getAttributeValue().toUpperCase().equals("NAME")) continue;
                    OMElement attrValElem = attrElem.getFirstChildWithName(new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue", "saml"));
                    if (attrValElem == null) throw new TrustException("Empty AttributeValue element in the SAML Assertion");
                    subject = attrValElem.getText();
                }
            }
        }
        if (subject == null) {
            throw new TrustException("To process an ActAs element, either the NameID of the SAML subject oran attribute with the Name should be present.");
        }
        this.actAs = subject;
    }

    public String getAppliesToAddress() {
        return this.appliesToAddress;
    }

    public X509Certificate getClientCert() {
        return this.clientCert;
    }

    public String getComputedKeyAlgo() {
        return this.computedKeyAlgo;
    }

    public byte[] getEphmeralKey() {
        return this.ephmeralKey;
    }

    public MessageContext getInMessageContext() {
        return this.inMessageContext;
    }

    public int getKeysize() {
        return this.keysize;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public byte[] getRequestEntropy() {
        return this.requestEntropy;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public byte[] getResponseEntropy() {
        return this.responseEntropy;
    }

    public OMElement getRstElement() {
        return this.rstElement;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public int getVersion() {
        return this.version;
    }

    public String getAddressingNs() {
        return this.addressingNs;
    }

    public String getWstNs() {
        return this.wstNs;
    }

    public String getSoapNs() {
        return this.soapNs;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setResponseEntropy(byte[] responseEntropy) {
        this.responseEntropy = responseEntropy;
    }

    public void setEphmeralKey(byte[] ephmeralKey) {
        this.ephmeralKey = ephmeralKey;
    }

    public String getClaimDialect() {
        return this.claimDialect;
    }

    public OMElement getClaimElem() {
        return this.claimElem;
    }

    public OMElement getAppliesToEpr() {
        return this.appliesToEpr;
    }

    public String getActAs() {
        return this.actAs;
    }

    public String getOverridenSubjectValue() {
        return this.overridenSubjectValue;
    }

    public void setOverridenSubjectValue(String overridenSubjectValue) {
        this.overridenSubjectValue = overridenSubjectValue;
    }
}

