/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.Token;
import org.apache.rahas.TokenPersister;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.ws.security.message.token.Reference;

public class SimpleTokenStore
implements TokenStorage,
Serializable {
    private static Log log = LogFactory.getLog(SimpleTokenStore.class);
    protected Map tokens = new Hashtable();
    protected volatile transient Boolean tokenStoreDisabled = null;
    protected transient TokenPersister tokenPersister = null;
    protected transient Integer maxInMemoryTokens = null;
    private static final int DEFAULT_IN_MEMORY_THRESHOLD = 500;
    protected List<String> persistedTokenIDList = new ArrayList<String>();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();

    @Override
    public void add(Token token) throws TrustException {
        block15: {
            if (this.tokenPersister == null) {
                this.getTokenPersister();
            }
            if (this.tokenPersister == null) {
                if (token != null && !"".equals(token.getId()) && token.getId() != null) {
                    this.writeLock.lock();
                    try {
                        if (this.tokens.keySet().size() == 0 || this.tokens.keySet().size() > 0 && !this.tokens.keySet().contains(token.getId())) {
                            this.tokens.put(token.getId(), token);
                            break block15;
                        }
                        throw new TrustException("tokenAlreadyExists", new String[]{token.getId()});
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
            } else {
                this.getThreshold();
                if (token != null && !"".equals(token.getId()) && token.getId() != null) {
                    if (this.tokens.keySet().size() == 0 && this.persistedTokenIDList.size() == 0) {
                        this.populatePersistedTokenIDs();
                    }
                    this.writeLock.lock();
                    try {
                        if (this.tokens.keySet().size() == 0 || this.tokens.keySet().size() > 0 && this.tokens.keySet().size() < this.maxInMemoryTokens && !this.isTokenExist(token.getId())) {
                            this.tokens.put(token.getId(), token);
                            break block15;
                        }
                        if (!(this.tokens.keySet().size() != this.maxInMemoryTokens.intValue() && this.tokens.keySet().size() <= this.maxInMemoryTokens || this.isTokenExist(token.getId()))) {
                            this.tokenPersister.notifyPersistence();
                            this.tokens.put(token.getId(), token);
                            break block15;
                        }
                        throw new TrustException("tokenAlreadyExists", new String[]{token.getId()});
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
            }
        }
    }

    @Override
    public void update(Token token) throws TrustException {
        block16: {
            if (this.tokenPersister == null) {
                this.getTokenPersister();
            }
            if (this.tokenPersister == null) {
                if (token != null && token.getId() != null && token.getId().trim().length() != 0) {
                    this.writeLock.lock();
                    try {
                        if (!this.tokens.keySet().contains(token.getId())) {
                            throw new TrustException("noTokenToUpdate", new String[]{token.getId()});
                        }
                        this.tokens.put(token.getId(), token);
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
            } else {
                if (this.tokens.keySet().size() == 0 && this.persistedTokenIDList.size() == 0) {
                    this.populatePersistedTokenIDs();
                }
                if (token != null && token.getId() != null && token.getId().trim().length() != 0) {
                    this.writeLock.lock();
                    try {
                        if (this.tokens.containsKey(token.getId())) {
                            this.tokens.put(token.getId(), token);
                            break block16;
                        }
                        if (this.persistedTokenIDList.contains(token.getId())) {
                            if (this.tokenPersister.isTokenExist(token.getId())) {
                                this.tokenPersister.updateToken(token);
                            }
                            break block16;
                        }
                        throw new TrustException("noTokenToUpdate", new String[]{token.getId()});
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTokenIdentifiers() throws TrustException {
        ArrayList<Object> identifiers = new ArrayList<Object>();
        if (this.tokenPersister == null) {
            this.getTokenPersister();
        }
        if (this.tokenPersister == null) {
            this.readLock.lock();
            try {
                Iterator iterator = this.tokens.keySet().iterator();
                while (iterator.hasNext()) {
                    identifiers.add(iterator.next());
                }
            }
            finally {
                this.readLock.unlock();
            }
            return identifiers.toArray(new String[identifiers.size()]);
        }
        if (this.tokens.keySet().size() == 0 && this.persistedTokenIDList.size() == 0) {
            this.populatePersistedTokenIDs();
        }
        this.readLock.lock();
        try {
            Iterator iterator = this.tokens.keySet().iterator();
            while (iterator.hasNext()) {
                identifiers.add(iterator.next());
            }
            if (this.persistedTokenIDList.size() != 0) {
                for (String persistedTokenID : this.persistedTokenIDList) {
                    identifiers.add(persistedTokenID);
                }
                String[] stringArray = identifiers.toArray(new String[identifiers.size()]);
                return stringArray;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return identifiers.toArray(new String[identifiers.size()]);
    }

    @Override
    public Token[] getValidTokens() throws TrustException {
        return this.getTokens(new int[]{1, 4});
    }

    @Override
    public Token[] getRenewedTokens() throws TrustException {
        return this.getTokens(4);
    }

    @Override
    public Token[] getCancelledTokens() throws TrustException {
        return this.getTokens(3);
    }

    @Override
    public Token[] getExpiredTokens() throws TrustException {
        return this.getTokens(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token[] getTokens(int[] states) throws TrustException {
        this.processTokenExpiry();
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.readLock.lock();
        try {
            block3: for (Token token : this.tokens.values()) {
                for (int i = 0; i < states.length; ++i) {
                    if (token.getState() != states[i]) continue;
                    tokens.add(token);
                    continue block3;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token[] getTokens(int state) throws TrustException {
        this.processTokenExpiry();
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.readLock.lock();
        try {
            for (Token token : this.tokens.values()) {
                if (token.getState() != state) continue;
                tokens.add(token);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Token getToken(String id) throws TrustException {
        if (this.tokenPersister == null) {
            this.getTokenPersister();
        }
        Token token = null;
        if (this.tokenPersister == null) {
            return this.getTokenFromMemory(id);
        }
        if (this.tokens.keySet().size() == 0 && this.persistedTokenIDList.size() == 0) {
            this.populatePersistedTokenIDs();
        }
        if ((token = this.getTokenFromMemory(id)) != null) return token;
        this.readLock.lock();
        try {
            Token tempToken;
            block11: {
                if (this.persistedTokenIDList.contains(id)) {
                    if (!this.tokenPersister.isTokenExist(id)) return token;
                    token = this.tokenPersister.retrieveToken(id);
                    this.setIfTokenExpired(token);
                    return token;
                }
                Iterator<String> iterator = this.persistedTokenIDList.iterator();
                while (iterator.hasNext()) {
                    String tokenID = iterator.next();
                    tempToken = this.tokenPersister.retrieveToken(tokenID);
                    OMElement elem = tempToken.getAttachedReference();
                    if (elem != null) {
                        if (tokenID.equals(SimpleTokenStore.getIdFromSTR(elem))) {
                            token = tempToken;
                            return token;
                        }
                    }
                    if ((elem = tempToken.getUnattachedReference()) == null) continue;
                    if (!tokenID.equals(SimpleTokenStore.getIdFromSTR(elem))) {
                        continue;
                    }
                    break block11;
                }
                return token;
            }
            token = tempToken;
            return token;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token getTokenFromMemory(String tokenID) throws TrustException {
        this.processTokenExpiry();
        this.readLock.lock();
        try {
            Token tempToken;
            Token token;
            block7: {
                token = (Token)this.tokens.get(tokenID);
                if (token != null) return token;
                Iterator iterator = this.tokens.values().iterator();
                while (iterator.hasNext()) {
                    tempToken = (Token)iterator.next();
                    OMElement elem = tempToken.getAttachedReference();
                    if (elem != null) {
                        if (tokenID.equals(SimpleTokenStore.getIdFromSTR(elem))) {
                            token = tempToken;
                            return token;
                        }
                    }
                    if ((elem = tempToken.getUnattachedReference()) == null) continue;
                    if (!tokenID.equals(SimpleTokenStore.getIdFromSTR(elem))) {
                        continue;
                    }
                    break block7;
                }
                return token;
            }
            token = tempToken;
            return token;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void removeToken(String id) throws TrustException {
        block12: {
            if (this.tokenPersister == null) {
                this.getTokenPersister();
            }
            if (this.tokenPersister == null) {
                this.writeLock.lock();
                try {
                    this.tokens.remove(id);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            if (this.tokens.keySet().size() == 0 && this.persistedTokenIDList.size() == 0) {
                this.populatePersistedTokenIDs();
            }
            this.writeLock.lock();
            try {
                if (this.tokens.containsKey(id)) {
                    this.tokens.remove(id);
                    break block12;
                }
                if (this.persistedTokenIDList.contains(id)) {
                    if (this.tokenPersister.isTokenExist(id)) {
                        this.tokenPersister.deleteToken(id);
                        this.persistedTokenIDList.remove(id);
                    }
                    break block12;
                }
                String errorMsg = "Token to be removed doesn't exist.";
                log.error((Object)errorMsg);
                throw new TrustException(errorMsg);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Token> getStorageTokens() throws TrustException {
        ArrayList<Token> storageTokenList = new ArrayList<Token>();
        this.readLock.lock();
        try {
            for (Token token : this.tokens.values()) {
                storageTokenList.add(token);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return storageTokenList;
    }

    @Override
    public void handlePersistence(List<?> persistingTokens) throws TrustException {
        if (this.tokenPersister == null) {
            this.getTokenPersister();
        }
        for (Object persistingToken : persistingTokens) {
            String persistingTokenID = null;
            this.writeLock.lock();
            try {
                persistingTokenID = (String)persistingToken;
                if (((Token)this.tokens.get(persistingTokenID)).isPersistenceEnabled()) {
                    this.tokenPersister.persistToken((Token)this.tokens.get(persistingTokenID));
                }
                this.tokens.remove(persistingTokenID);
                this.persistedTokenIDList.add(persistingTokenID);
            }
            catch (TrustException e) {
                String errorMsg = "Error in persisting token: " + persistingTokenID;
                log.error((Object)errorMsg, (Throwable)e);
                throw new TrustException(errorMsg, e);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void handlePersistenceOnShutdown() throws TrustException {
        if (this.tokenPersister == null) {
            this.getTokenPersister();
        }
        if (this.tokenPersister != null) {
            this.readLock.lock();
            try {
                for (Object token : this.tokens.values()) {
                    if (!((Token)token).isPersistenceEnabled()) continue;
                    this.tokenPersister.persistToken((Token)token);
                }
            }
            catch (TrustException e) {
                String errorMessage = "Error in persisting tokens on module shut down..";
                log.error((Object)errorMessage, (Throwable)e);
                throw new TrustException(errorMessage, e);
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    protected void processTokenExpiry() throws TrustException {
        this.readLock.lock();
        try {
            for (Token token : this.tokens.values()) {
                this.setIfTokenExpired(token);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static synchronized String getIdFromSTR(OMElement str) {
        OMElement child = str.getFirstElement();
        if (child == null) {
            return null;
        }
        if (child.getQName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"))) {
            return child.getText();
        }
        if (child.getQName().equals(Reference.TOKEN)) {
            String uri = child.getAttributeValue(new QName("URI"));
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
            return uri;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTokenPersister() {
        if (MessageContext.getCurrentMessageContext() != null && this.tokenPersister == null) {
            SimpleTokenStore simpleTokenStore = this;
            synchronized (simpleTokenStore) {
                if (this.tokenPersister == null) {
                    this.tokenPersister = (TokenPersister)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("org.apache.rahas.TokenPersister");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getThreshold() throws TrustException {
        try {
            if (this.maxInMemoryTokens == null) {
                SimpleTokenStore simpleTokenStore = this;
                synchronized (simpleTokenStore) {
                    if (this.maxInMemoryTokens == null && MessageContext.getCurrentMessageContext() != null) {
                        SAMLTokenIssuerConfig issuerConfig = (SAMLTokenIssuerConfig)MessageContext.getCurrentMessageContext().getProperty("IssuerConfig");
                        this.maxInMemoryTokens = Integer.parseInt(issuerConfig.getPersisterPropertyMap().get("InMemoryThreshold").toString());
                    }
                }
            }
            if (this.maxInMemoryTokens == null) {
                this.maxInMemoryTokens = 500;
            }
        }
        catch (NumberFormatException e) {
            String errorMessage = "errorReadingStorageThreshold";
            log.error((Object)errorMessage, (Throwable)e);
            throw new TrustException(errorMessage, e);
        }
    }

    private boolean isTokenExist(String tokenId) {
        return this.tokens.keySet().contains(tokenId) || this.persistedTokenIDList.contains(tokenId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatePersistedTokenIDs() {
        if (this.persistedTokenIDList.size() == 0) {
            SimpleTokenStore simpleTokenStore = this;
            synchronized (simpleTokenStore) {
                String[] persistedTokenIDs;
                if (this.persistedTokenIDList.size() == 0 && this.tokenPersister.isTokensExist() && (persistedTokenIDs = this.tokenPersister.retrieveTokenIDs()) != null) {
                    this.writeLock.lock();
                    try {
                        this.persistedTokenIDList.addAll(Arrays.asList(persistedTokenIDs));
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
            }
        }
    }

    private void setIfTokenExpired(Token token) {
        if (token.getExpires() != null && token.getExpires().getTime() < System.currentTimeMillis()) {
            token.setState(2);
        }
    }
}

