/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.ws.security.util.XmlSchemaDateFormat;

public class Token
implements Externalizable {
    private static Log log = LogFactory.getLog(Token.class);
    public static final int ISSUED = 1;
    public static final int EXPIRED = 2;
    public static final int CANCELLED = 3;
    public static final int RENEWED = 4;
    private String id;
    private int state = -1;
    private OMElement token;
    private OMElement previousToken;
    private OMElement attachedReference;
    private OMElement unattachedReference;
    private Properties properties;
    private boolean changed;
    private byte[] secret;
    private Date created;
    private Date expires;
    private String issuerAddress;
    private String encrKeySha1Value;
    private boolean persistenceEnabled = false;

    public Token() {
    }

    public Token(String id, Date created, Date expires) {
        this.id = id;
        this.created = created;
        this.expires = expires;
    }

    public Token(String id, OMElement tokenElem, Date created, Date expires) throws TrustException {
        this.id = id;
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), tokenElem.getXMLStreamReader());
        stAXOMBuilder.setNamespaceURIInterning(true);
        this.token = stAXOMBuilder.getDocumentElement();
        this.created = created;
        this.expires = expires;
    }

    public Token(String id, OMElement tokenElem, OMElement lifetimeElem) throws TrustException {
        this.id = id;
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), tokenElem.getXMLStreamReader());
        stAXOMBuilder.setNamespaceURIInterning(true);
        this.token = stAXOMBuilder.getDocumentElement();
        this.processLifeTime(lifetimeElem);
    }

    private void processLifeTime(OMElement lifetimeElem) throws TrustException {
        try {
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            OMElement createdElem = lifetimeElem.getFirstChildWithName(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created"));
            this.created = zulu.parse(createdElem.getText());
            OMElement expiresElem = lifetimeElem.getFirstChildWithName(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires"));
            this.expires = zulu.parse(expiresElem.getText());
        }
        catch (OMException e) {
            throw new TrustException("lifeTimeProcessingError", new String[]{lifetimeElem.toString()}, e);
        }
        catch (ParseException e) {
            throw new TrustException("lifeTimeProcessingError", new String[]{lifetimeElem.toString()}, e);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean chnaged) {
        this.changed = chnaged;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public OMElement getToken() {
        return this.token;
    }

    public void setToken(OMElement token) {
        this.token = token;
    }

    public String getId() {
        return this.id;
    }

    public OMElement getPreviousToken() {
        return this.previousToken;
    }

    public void setPreviousToken(OMElement presivousToken) {
        this.previousToken = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), presivousToken.getXMLStreamReader()).getDocumentElement();
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public void setSecret(byte[] secret) {
        this.secret = secret;
    }

    public OMElement getAttachedReference() {
        return this.attachedReference;
    }

    public void setAttachedReference(OMElement attachedReference) {
        if (attachedReference != null) {
            this.attachedReference = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), attachedReference.getXMLStreamReader()).getDocumentElement();
        }
    }

    public OMElement getUnattachedReference() {
        return this.unattachedReference;
    }

    public void setUnattachedReference(OMElement unattachedReference) {
        if (unattachedReference != null) {
            this.unattachedReference = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), unattachedReference.getXMLStreamReader()).getDocumentElement();
        }
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public String getIssuerAddress() {
        return this.issuerAddress;
    }

    public void setIssuerAddress(String issuerAddress) {
        this.issuerAddress = issuerAddress;
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public void setPersistenceEnabled(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeInt(this.state);
        String stringElement = this.convertOMElementToString(this.token);
        out.writeObject(stringElement);
        stringElement = this.convertOMElementToString(this.previousToken);
        out.writeObject(stringElement);
        stringElement = this.convertOMElementToString(this.attachedReference);
        out.writeObject(stringElement);
        stringElement = this.convertOMElementToString(this.unattachedReference);
        out.writeObject(stringElement);
        out.writeObject(this.properties);
        out.writeBoolean(this.changed);
        int secretLength = 0;
        if (null != this.secret) {
            secretLength = this.secret.length;
        }
        out.writeInt(secretLength);
        if (0 != secretLength) {
            out.write(this.secret);
        }
        out.writeObject(this.created);
        out.writeObject(this.expires);
        out.writeObject(this.issuerAddress);
        out.writeObject(this.encrKeySha1Value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (String)in.readObject();
        this.state = in.readInt();
        String stringElement = (String)in.readObject();
        this.token = this.convertStringToOMElement(stringElement);
        stringElement = (String)in.readObject();
        this.previousToken = this.convertStringToOMElement(stringElement);
        stringElement = (String)in.readObject();
        this.attachedReference = this.convertStringToOMElement(stringElement);
        stringElement = (String)in.readObject();
        this.unattachedReference = this.convertStringToOMElement(stringElement);
        this.properties = (Properties)in.readObject();
        this.changed = in.readBoolean();
        int secretLength = in.readInt();
        if (0 != secretLength) {
            byte[] buffer = new byte[secretLength];
            if (secretLength != in.read(buffer)) {
                throw new IllegalStateException("Bytes read from the secret key is not equal to serialized length");
            }
            this.secret = buffer;
        } else {
            this.secret = null;
        }
        this.created = (Date)in.readObject();
        this.expires = (Date)in.readObject();
        this.issuerAddress = (String)in.readObject();
        this.encrKeySha1Value = (String)in.readObject();
    }

    private String convertOMElementToString(OMElement element) throws IOException {
        String serializedToken = "";
        if (null == element) {
            return serializedToken;
        }
        try {
            serializedToken = element.toStringWithConsume();
        }
        catch (XMLStreamException e) {
            throw new IOException("Could not serialize token OM element");
        }
        return serializedToken;
    }

    private OMElement convertStringToOMElement(String stringElement) throws IOException {
        if (null == stringElement || stringElement.trim().equals("")) {
            return null;
        }
        try {
            StringReader in = new StringReader(stringElement);
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(in);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement documentElement = builder.getDocumentElement();
            XMLStreamReader llomReader = documentElement.getXMLStreamReader();
            OMFactory doomFactory = DOOMAbstractFactory.getOMFactory();
            StAXOMBuilder doomBuilder = new StAXOMBuilder(doomFactory, llomReader);
            return doomBuilder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            log.error((Object)"Cannot convert de-serialized string to OMElement. Could not create XML stream.", (Throwable)e);
            IOException ex = new IOException("Cannot convert de-serialized string to OMElement. Could not create XML stream.");
            ex.initCause(e);
            throw ex;
        }
    }
}

