/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.SimpleTokenStore;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.AbstractIssuerConfig;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.apache.xerces.util.SecurityManager;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLSubjectStatement;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TrustUtil {
    private static final QName NAME = new QName("name");
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static Log logger = LogFactory.getLog(TrustUtil.class);

    public static Element createSecurityTokenReference(Document doc, String refUri, String refValueType) {
        Reference ref = new Reference(doc);
        ref.setURI(refUri);
        if (refValueType != null) {
            ref.setValueType(refValueType);
        }
        SecurityTokenReference str = new SecurityTokenReference(doc);
        str.setReference(ref);
        return str.getElement();
    }

    public static Element createSecurityTokenReferenceWithTokenType(Document doc, String refUri, String refValueType, String tokenType) {
        Reference ref = new Reference(doc);
        ref.setURI("#" + refUri);
        if (refValueType != null) {
            ref.setValueType(refValueType);
        }
        SecurityTokenReference str = new SecurityTokenReference(doc);
        str.setReference(ref);
        Element securityTokenReference = str.getElement();
        securityTokenReference.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse11", "http://docs.oasis-open.org/wss/oasis-wsswssecurity-secext-1.1.xsd");
        securityTokenReference.setAttributeNS("http://docs.oasis-open.org/wss/oasis-wsswssecurity-secext-1.1.xsd", "wsse11:TokenType", tokenType);
        return securityTokenReference;
    }

    public static OMElement createRequestSecurityTokenResponseElement(int version, OMElement parent) throws TrustException {
        return TrustUtil.createOMElement(parent, TrustUtil.getWSTNamespace(version), "RequestSecurityTokenResponse", "wst");
    }

    public static OMElement createRequestSecurityTokenResponseCollectionElement(int version, OMElement parent) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        return TrustUtil.createOMElement(parent, ns, "RequestSecurityTokenResponseCollection", "wst");
    }

    public static OMElement createRequestedSecurityTokenElement(int version, OMElement parent) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        return TrustUtil.createOMElement(parent, ns, "RequestedSecurityToken", "wst");
    }

    public static OMElement createRequestSecurityTokenElement(int version) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        return fac.createOMElement("RequestSecurityToken", ns, "wst");
    }

    public static OMElement createRequestedProofTokenElement(int version, OMElement parent) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        return TrustUtil.createOMElement(parent, ns, "RequestedProofToken", "wst");
    }

    public static OMElement createEntropyElement(int version, OMElement parent) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        return TrustUtil.createOMElement(parent, ns, "Entropy", "wst");
    }

    public static OMElement createComputedKeyElement(int version, OMElement parent) throws TrustException {
        return TrustUtil.createOMElement(parent, TrustUtil.getWSTNamespace(version), "ComputedKey", "wst");
    }

    public static OMElement createRequestTypeElement(int version, OMElement parent, String value) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        OMElement elem = TrustUtil.createOMElement(parent, ns, "RequestType", "wst");
        if ("/Issue".equals(value) || "/Cancel".equals(value) || "/Renew".equals(value) || "/Validate".equals(value)) {
            elem.setText(TrustUtil.getWSTNamespaceForRSTRequestTye(version) + value);
        } else {
            elem.setText(value);
        }
        return elem;
    }

    public static OMElement createTokenTypeElement(int version, OMElement parent) throws TrustException {
        return TrustUtil.createOMElement(parent, TrustUtil.getWSTNamespace(version), "TokenType", "wst");
    }

    public static OMElement createValidateTargetElement(int version, OMElement parent, OMElement str) throws TrustException {
        OMElement validateTarget = TrustUtil.createOMElement(parent, TrustUtil.getWSTNamespace(version), "ValidateTarget", "wst");
        validateTarget.addChild((OMNode)str);
        return validateTarget;
    }

    public static OMElement createRenewTargetElement(int version, OMElement parent, OMElement str) throws TrustException {
        OMElement renewTarget = TrustUtil.createOMElement(parent, TrustUtil.getWSTNamespace(version), "RenewTarget", "wst");
        renewTarget.addChild((OMNode)str);
        return renewTarget;
    }

    public static OMElement createBinarySecretElement(int version, OMElement parent, String type) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        OMElement elem = TrustUtil.createOMElement(parent, ns, "BinarySecret", "wst");
        if (type != null) {
            elem.addAttribute(elem.getOMFactory().createOMAttribute("Type", null, ns + type));
        }
        return elem;
    }

    public static OMElement createComputedKeyAlgorithm(int version, OMElement parent, String algoId) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        OMElement elem = TrustUtil.createOMElement(parent, ns, "ComputedKeyAlgorithm", "wst");
        elem.setText(ns + algoId);
        return elem;
    }

    public static OMElement createRequestedUnattachedRef(int version, OMElement parent, String refUri, String refValueType) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        OMElement elem = TrustUtil.createOMElement(parent, ns, "RequestedUnattachedReference", "wst");
        elem.addChild((OMNode)((OMElement)TrustUtil.createSecurityTokenReference(((Element)parent).getOwnerDocument(), refUri, refValueType)));
        return elem;
    }

    public static OMElement createRequestedAttachedRef(int version, OMElement parent, String refUri, String refValueType) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        OMElement elem = TrustUtil.createOMElement(parent, ns, "RequestedAttachedReference", "wst");
        elem.addChild((OMNode)((OMElement)TrustUtil.createSecurityTokenReference(((Element)parent).getOwnerDocument(), refUri, refValueType)));
        return elem;
    }

    public static void createRequestedAttachedRef(OMElement rstrElem, String id, int version) throws TrustException {
        OMFactory fac = null;
        OMElement rar = null;
        OMElement str = null;
        OMElement ki = null;
        String ns = TrustUtil.getWSTNamespace(version);
        fac = rstrElem.getOMFactory();
        rar = fac.createOMElement(new QName(ns, "RequestedAttachedReference", "wst"), (OMContainer)rstrElem);
        str = fac.createOMElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference", "wsse"), (OMContainer)rar);
        ki = fac.createOMElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier", "wsse"), (OMContainer)str);
        ki.addAttribute("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", null);
        ki.setText(id);
    }

    public static void createRequestedUnattachedRef(OMElement rstrElem, String id, int version) throws TrustException {
        OMFactory fac = null;
        OMElement rar = null;
        OMElement str = null;
        OMElement ki = null;
        String ns = TrustUtil.getWSTNamespace(version);
        fac = rstrElem.getOMFactory();
        rar = fac.createOMElement(new QName(ns, "RequestedUnattachedReference", "wst"), (OMContainer)rstrElem);
        str = fac.createOMElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference", "wsse"), (OMContainer)rar);
        ki = fac.createOMElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier", "wsse"), (OMContainer)str);
        ki.addAttribute("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", null);
        ki.setText(id);
    }

    public static OMElement createKeySizeElement(int version, OMElement parent, int size) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        OMElement ksElem = TrustUtil.createOMElement(parent, ns, "KeySize", "wst");
        ksElem.setText(Integer.toString(size));
        return ksElem;
    }

    public static OMElement createKeyTypeElement(int version, OMElement parent, String type) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        OMElement ktElem = TrustUtil.createOMElement(parent, ns, "KeyType", "wst");
        if ("/Bearer".equals(type) || "/PublicKey".equals(type) || "/SymmetricKey".equals(type)) {
            ktElem.setText(ns + type);
        } else {
            ktElem.setText(type);
        }
        return ktElem;
    }

    public static OMElement createRequestedTokenCanceledElement(int version, OMElement parent) throws TrustException {
        return TrustUtil.createOMElement(parent, TrustUtil.getWSTNamespace(version), "RequestedTokenCancelled", "wst");
    }

    public static OMElement createLifetimeElement(int version, OMElement parent, String created, String expires) throws TrustException {
        String ns = TrustUtil.getWSTNamespace(version);
        OMElement ltElem = TrustUtil.createOMElement(parent, ns, "Lifetime", "wst");
        OMElement createdElem = TrustUtil.createOMElement(ltElem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created", "wsu");
        createdElem.setText(created);
        OMElement expiresElem = TrustUtil.createOMElement(ltElem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires", "wsu");
        expiresElem.setText(expires);
        return ltElem;
    }

    public static OMElement createLifetimeElement(int version, OMElement parent, long ttl) throws TrustException {
        Date creationTime = new Date();
        Date expirationTime = new Date();
        expirationTime.setTime(creationTime.getTime() + ttl);
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        return TrustUtil.createLifetimeElement(version, parent, zulu.format(creationTime), zulu.format(expirationTime));
    }

    public static OMElement createAppliesToElement(OMElement parent, String address, String addressingNs) {
        OMElement appliesToElem = TrustUtil.createOMElement(parent, "http://schemas.xmlsoap.org/ws/2004/09/policy", "AppliesTo", "wsp");
        OMElement eprElem = TrustUtil.createOMElement(appliesToElem, addressingNs, "EndpointReference", "wsa");
        OMElement addressElem = TrustUtil.createOMElement(eprElem, addressingNs, "Address", "wsa");
        addressElem.setText(address);
        return appliesToElem;
    }

    public static String getActionValue(int version, String action) throws TrustException {
        if ("/RST/Issue".equals(action) || "/RST/Cancel".equals(action) || "/RST/Renew".equals(action) || "/RST/Validate".equals(action) || "/RST/SCT".equals(action) || "/RSTR/Issue".equals(action) || "/RSTR/Cancel".equals(action) || "/RSTR/Renew".equals(action) || "/RSTR/Validate".equals(action) || "/RSTR/SCT".equals(action) || "/RSTRC/IssueFinal".equals(action)) {
            return TrustUtil.getWSTNamespaceForRSTRequestTye(version) + action;
        }
        return action;
    }

    public static SOAPEnvelope createSOAPEnvelope(String nsUri) {
        if (nsUri != null && "http://schemas.xmlsoap.org/soap/envelope/".equals(nsUri)) {
            return DOOMAbstractFactory.getSOAP11Factory().getDefaultEnvelope();
        }
        return DOOMAbstractFactory.getSOAP12Factory().getDefaultEnvelope();
    }

    private static OMElement createOMElement(OMElement parent, String ns, String ln, String prefix) {
        return parent.getOMFactory().createOMElement(new QName(ns, ln, prefix), (OMContainer)parent);
    }

    public static String getWSTNamespace(int version) throws TrustException {
        switch (version) {
            case 1: {
                return "http://schemas.xmlsoap.org/ws/2005/02/trust";
            }
            case 2: {
                return "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            }
            case 3: {
                return "http://docs.oasis-open.org/ws-sx/ws-trust/200802";
            }
        }
        throw new TrustException("unsupportedWSTVersion");
    }

    public static int getWSTVersion(String ns) throws TrustException {
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust".equals(ns)) {
            return 1;
        }
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(ns)) {
            return 2;
        }
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200802".equals(ns)) {
            return 3;
        }
        throw new TrustException("unsupportedWSTVersion");
    }

    public static TokenStorage getTokenStore(MessageContext msgCtx) {
        ConfigurationContext configCtx = msgCtx.getConfigurationContext();
        return TrustUtil.getTokenStore(configCtx);
    }

    public static TokenStorage getTokenStore(ConfigurationContext ctx) {
        TokenStorage storage = (TokenStorage)ctx.getProperty("org.apache.rahas.TokenStorage");
        if (storage == null) {
            storage = new SimpleTokenStore();
            ctx.setProperty("org.apache.rahas.TokenStorage", (Object)storage);
        }
        return storage;
    }

    protected byte[] generateEphemeralKey(int keySize) throws TrustException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[keySize / 8];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new TrustException("Error in creating the ephemeral key", e);
        }
    }

    protected byte[] generateEphemeralKey(byte[] reqEnt, byte[] respEnt, String algo, int keySize) throws TrustException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[keySize / 8];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new TrustException("Error in creating the ephemeral key", e);
        }
    }

    public static OMElement createCancelTargetElement(int version, OMElement parent) throws TrustException {
        return TrustUtil.createOMElement(parent, TrustUtil.getWSTNamespace(version), "CancelTarget", "wst");
    }

    public static OMElement createClaims(int version, OMElement parent, String dialect) throws TrustException {
        OMElement omElem = TrustUtil.createOMElement(parent, TrustUtil.getWSTNamespace(version), "Claims", "wst");
        OMNamespace ns = omElem.getOMFactory().createOMNamespace(TrustUtil.getWSTNamespace(version), "wsp");
        omElem.addAttribute("Dialect", dialect, ns);
        return omElem;
    }

    public static OMElement createCancelRequest(String tokenId, int version) throws TrustException {
        OMElement rst = TrustUtil.createRequestSecurityTokenElement(version);
        TrustUtil.createRequestTypeElement(version, rst, "/Cancel");
        OMElement cancelTargetEle = TrustUtil.createCancelTargetElement(version, rst);
        OMFactory factory = rst.getOMFactory();
        OMElement secTokenRefEle = factory.createOMElement("SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        OMElement refEle = factory.createOMElement(Reference.TOKEN);
        refEle.addAttribute(factory.createOMAttribute("URI", null, tokenId));
        secTokenRefEle.addChild((OMNode)refEle);
        cancelTargetEle.addChild((OMNode)secTokenRefEle);
        return rst;
    }

    public static Properties toProperties(OMElement cryptoElem) {
        Properties properties = new Properties();
        Iterator propIter = cryptoElem.getChildElements();
        while (propIter.hasNext()) {
            OMElement propElem = (OMElement)propIter.next();
            String name = propElem.getAttribute(NAME).getAttributeValue().trim();
            String value = propElem.getText().trim();
            properties.setProperty(name, value);
        }
        properties.setProperty("org.apache.ws.security.crypto.provider", cryptoElem.getAttribute(AbstractIssuerConfig.PROVIDER).getAttributeValue().trim());
        return properties;
    }

    public static String getSAML11SubjectConfirmationMethod(SAMLAssertion assertion) {
        SAMLSubjectStatement stmt;
        Iterator subjectConfirmations;
        String subjectConfirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
        Iterator statements = assertion.getStatements();
        if (statements.hasNext() && (subjectConfirmations = (stmt = (SAMLSubjectStatement)statements.next()).getSubject().getConfirmationMethods()).hasNext()) {
            subjectConfirmationMethod = (String)subjectConfirmations.next();
        }
        return subjectConfirmationMethod;
    }

    public static String getSAML2SubjectConfirmationMethod(Assertion assertion) {
        String subjectConfirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
        List subjectConfirmations = assertion.getSubject().getSubjectConfirmations();
        if (subjectConfirmations.size() > 0) {
            subjectConfirmationMethod = ((SubjectConfirmation)subjectConfirmations.get(0)).getMethod();
        }
        return subjectConfirmationMethod;
    }

    public static String getWSTNamespaceForRSTRequestTye(int version) throws TrustException {
        switch (version) {
            case 1: {
                return "http://schemas.xmlsoap.org/ws/2005/02/trust";
            }
            case 2: {
                return "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            }
            case 3: {
                return "http://schemas.xmlsoap.org/ws/2005/02/trust";
            }
        }
        throw new TrustException("unsupportedWSTVersion");
    }

    public static OMElement createActAsElement(OMElement parent, int version, OMElement samlToken) throws TrustException {
        if (version < 3) {
            throw new TrustException("ActAs element is not supported in this trust version.");
        }
        OMElement actAsElem = TrustUtil.createOMElement(parent, TrustUtil.getWSTNamespace(version), "ActAs", "wst");
        if (samlToken == null) {
            throw new TrustException("The child element of the ActAs element should not be null");
        }
        actAsElem.addChild((OMNode)samlToken);
        return actAsElem;
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtdor secure-processing.");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    public static boolean isDoomParserPoolUsed() {
        String doomParserPoolSwitch = System.getProperty("rampart.axiom.parser.pool");
        boolean doomParserPoolEnabled = true;
        if (StringUtils.isNotBlank((String)doomParserPoolSwitch) && !Boolean.parseBoolean(doomParserPoolSwitch)) {
            doomParserPoolEnabled = false;
        }
        return doomParserPoolEnabled;
    }
}

