/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.rahas.impl.util.SAMLAttributeCallback;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.apache.rahas.impl.util.SAMLNameIdentifierCallback;
import org.apache.rahas.impl.util.SAMLUtils;
import org.apache.ws.security.KerberosTokenPrincipal;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAudienceRestrictionCondition;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SAMLTokenIssuer
implements TokenIssuer {
    protected String configParamName;
    protected OMElement configElement;
    protected String configFile;
    protected String audienceRestriction = null;
    private static Log log = LogFactory.getLog(SAMLTokenIssuer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SOAPEnvelope issue(RahasData data) throws TrustException {
        try {
            Token assertionToken;
            OMElement rstrElem;
            MessageContext inMsgCtx = data.getInMessageContext();
            SAMLTokenIssuerConfig config = null;
            if (this.configElement != null) {
                config = new SAMLTokenIssuerConfig(this.configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
            }
            if (config == null && this.configFile != null) {
                config = new SAMLTokenIssuerConfig(this.configFile);
            }
            if (config == null && this.configParamName != null) {
                Parameter param = inMsgCtx.getParameter(this.configParamName);
                if (param != null && param.getParameterElement() != null) {
                    config = new SAMLTokenIssuerConfig(param.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
                } else {
                    throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
                }
            }
            if (config == null) {
                throw new TrustException("configurationIsNull");
            }
            if (TokenIssuerUtil.isPersisterConfigured(config)) {
                TokenIssuerUtil.manageTokenPersistenceSettings(config, inMsgCtx);
            }
            if (!TrustUtil.isDoomParserPoolUsed()) {
                DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
            }
            SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
            Crypto crypto = config.cryptoElement != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(config.cryptoElement), (ClassLoader)inMsgCtx.getAxisService().getClassLoader()) : CryptoFactory.getInstance((String)config.cryptoPropertiesFile, (ClassLoader)inMsgCtx.getAxisService().getClassLoader());
            if (StringUtils.isBlank((String)data.getAppliesToAddress())) {
                this.audienceRestriction = "defaultAudienceRestriction";
            }
            this.audienceRestriction = data.getAppliesToAddress();
            Date creationTime = new Date();
            Date expirationTime = new Date();
            expirationTime.setTime(creationTime.getTime() + config.ttl);
            Document doc = ((Element)env).getOwnerDocument();
            int keySize = data.getKeysize();
            keySize = keySize == -1 ? config.keySize : keySize;
            String keyType = data.getKeyType();
            if (StringUtils.isBlank((String)keyType)) {
                if (StringUtils.isNotBlank((String)data.getAppliesToAddress())) {
                    keyType = data.getRstElement().getNamespace().getNamespaceURI() + "/SymmetricKey";
                } else {
                    throw new TrustException("InvalidRequest", new String[]{"Requested KeyType is missing"});
                }
            }
            SAMLAssertion assertion = keyType.endsWith("/SymmetricKey") || keyType.endsWith("/PublicKey") ? this.createHoKAssertion(config, doc, crypto, creationTime, expirationTime, data) : (keyType.endsWith("/Bearer") ? this.createBearerAssertion(config, doc, crypto, creationTime, expirationTime, data) : this.createBearerAssertion(config, doc, crypto, creationTime, expirationTime, data));
            int wstVersion = data.getVersion();
            if (1 == wstVersion) {
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
            } else {
                OMElement rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
            }
            TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            if (keyType.endsWith("/SymmetricKey")) {
                TrustUtil.createKeySizeElement(wstVersion, rstrElem, keySize);
            }
            if (config.addRequestedAttachedRef) {
                this.createAttachedRef(rstrElem, assertion.getId(), wstVersion);
            }
            if (config.addRequestedUnattachedRef) {
                this.createUnattachedRef(rstrElem, assertion.getId(), wstVersion);
            }
            if (data.getAppliesToAddress() != null) {
                TrustUtil.createAppliesToElement(rstrElem, data.getAppliesToAddress(), data.getAddressingNs());
            }
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            TrustUtil.createLifetimeElement(wstVersion, rstrElem, zulu.format(creationTime), zulu.format(expirationTime));
            OMElement reqSecTokenElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
            try {
                Node tempNode = assertion.toDOM();
                reqSecTokenElem.addChild((OMNode)((Element)rstrElem).getOwnerDocument().importNode(tempNode, true));
                assertionToken = new Token(assertion.getId(), (OMElement)assertion.toDOM(), creationTime, expirationTime);
                assertionToken.setSecret(data.getEphmeralKey());
            }
            catch (SAMLException e) {
                throw new TrustException("samlConverstionError", e);
            }
            if (keyType.endsWith("/SymmetricKey") && config.keyComputation != 1) {
                TokenIssuerUtil.handleRequestedProofToken(data, wstVersion, config, rstrElem, assertionToken, doc);
            }
            if (!config.isTokenStoreDisabled()) {
                assertionToken.setPersistenceEnabled(true);
                TrustUtil.getTokenStore(inMsgCtx).add(assertionToken);
            }
            SOAPEnvelope sOAPEnvelope = env;
            return sOAPEnvelope;
        }
        finally {
            if (!TrustUtil.isDoomParserPoolUsed()) {
                DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
            }
        }
    }

    protected void createAttachedRef(OMElement rstrElem, String id, int version) throws TrustException {
        OMFactory fac = null;
        OMElement rar = null;
        OMElement str = null;
        OMElement ki = null;
        String ns = TrustUtil.getWSTNamespace(version);
        fac = rstrElem.getOMFactory();
        rar = fac.createOMElement(new QName(ns, "RequestedAttachedReference", "wst"), (OMContainer)rstrElem);
        str = fac.createOMElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference", "wsse"), (OMContainer)rar);
        ki = fac.createOMElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier", "wsse"), (OMContainer)str);
        ki.addAttribute("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", null);
        ki.setText(id);
    }

    protected void createUnattachedRef(OMElement rstrElem, String id, int version) throws TrustException {
        OMFactory fac = null;
        OMElement rar = null;
        OMElement str = null;
        OMElement ki = null;
        String ns = TrustUtil.getWSTNamespace(version);
        fac = rstrElem.getOMFactory();
        rar = fac.createOMElement(new QName(ns, "RequestedUnattachedReference", "wst"), (OMContainer)rstrElem);
        str = fac.createOMElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference", "wsse"), (OMContainer)rar);
        ki = fac.createOMElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier", "wsse"), (OMContainer)str);
        ki.addAttribute("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", null);
        ki.setText(id);
    }

    protected SAMLAssertion createBearerAssertion(SAMLTokenIssuerConfig config, Document doc, Crypto crypto, Date creationTime, Date expirationTime, RahasData data) throws TrustException {
        try {
            Principal principal = data.getPrincipal();
            if (principal instanceof WSUsernameTokenPrincipal || principal instanceof KerberosTokenPrincipal) {
                SAMLNameIdentifier nameId = null;
                if (config.getCallbackHandler() != null) {
                    SAMLNameIdentifierCallback cb = new SAMLNameIdentifierCallback(data);
                    cb.setUserId(principal.getName());
                    SAMLCallbackHandler callbackHandler = config.getCallbackHandler();
                    callbackHandler.handle(cb);
                    nameId = cb.getNameId();
                } else {
                    nameId = new SAMLNameIdentifier(principal.getName(), null, "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
                }
                return this.createAuthAssertion(doc, "urn:oasis:names:tc:SAML:1.0:cm:bearer", nameId, null, config, crypto, creationTime, expirationTime, data);
            }
            throw new TrustException("samlUnsupportedPrincipal", new String[]{principal.getClass().getName()});
        }
        catch (SAMLException e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    protected SAMLAssertion createHoKAssertion(SAMLTokenIssuerConfig config, Document doc, Crypto crypto, Date creationTime, Date expirationTime, RahasData data) throws TrustException {
        String keyType = data.getKeyType();
        if (StringUtils.isBlank((String)keyType)) {
            keyType = data.getRstElement().getNamespace().getNamespaceURI() + "/SymmetricKey";
        }
        if (keyType.endsWith("/SymmetricKey")) {
            Element encryptedKeyElem;
            SAMLNameIdentifier nameId = null;
            X509Certificate serviceCert = null;
            try {
                if (data.getPrincipal() != null) {
                    String subjectNameId = data.getPrincipal().getName();
                    nameId = new SAMLNameIdentifier(subjectNameId, null, "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
                }
                serviceCert = this.getServiceCert(config, crypto, data.getAppliesToAddress());
                WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
                encrKeyBuilder.setKeyIdentifierType(8);
                encrKeyBuilder.setUseThisCert(serviceCert);
                int keysize = data.getKeysize();
                keysize = keysize != -1 ? keysize : config.keySize;
                encrKeyBuilder.setKeySize(keysize);
                encrKeyBuilder.setEphemeralKey(TokenIssuerUtil.getSharedSecret(data, config.keyComputation, keysize));
                encrKeyBuilder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
                encrKeyBuilder.prepare(doc, crypto);
                byte[] tempKey = new byte[keysize / 8];
                System.arraycopy(encrKeyBuilder.getEphemeralKey(), 0, tempKey, 0, keysize / 8);
                data.setEphmeralKey(tempKey);
                encryptedKeyElem = encrKeyBuilder.getEncryptedKeyElement();
            }
            catch (Exception e) {
                throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", new String[]{serviceCert.getSubjectDN().getName()}, e);
            }
            return this.createAttributeAssertion(doc, data, encryptedKeyElem, nameId, config, crypto, creationTime, expirationTime);
        }
        try {
            String subjectNameId = data.getPrincipal().getName();
            SAMLNameIdentifier nameId = new SAMLNameIdentifier(subjectNameId, null, "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            X509Certificate clientCert = data.getClientCert();
            if (clientCert == null) {
                X509Certificate[] certs = crypto.getCertificates(data.getPrincipal().getName());
                clientCert = certs[0];
            }
            byte[] clientCertBytes = clientCert.getEncoded();
            String base64Cert = Base64.encode((byte[])clientCertBytes);
            Text base64CertText = doc.createTextNode(base64Cert);
            Element x509CertElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            x509CertElem.appendChild(base64CertText);
            Element x509DataElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Data");
            x509DataElem.appendChild(x509CertElem);
            return this.createAuthAssertion(doc, "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key", nameId, x509DataElem, config, crypto, creationTime, expirationTime, data);
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    private X509Certificate getServiceCert(SAMLTokenIssuerConfig config, Crypto crypto, String serviceAddress) throws WSSecurityException {
        if (serviceAddress != null && !"".equals(serviceAddress)) {
            String alias = (String)config.trustedServices.get(serviceAddress);
            if (alias != null) {
                return crypto.getCertificates(alias)[0];
            }
            alias = (String)config.trustedServices.get("*");
            return crypto.getCertificates(alias)[0];
        }
        String alias = (String)config.trustedServices.get("*");
        return crypto.getCertificates(alias)[0];
    }

    private SAMLAssertion createAttributeAssertion(Document doc, RahasData data, Element keyInfoContent, SAMLNameIdentifier subjectNameId, SAMLTokenIssuerConfig config, Crypto crypto, Date notBefore, Date notAfter) throws TrustException {
        try {
            SAMLCallbackHandler handler;
            SAMLAttributeCallback cb;
            String[] confirmationMethods = new String[]{"urn:oasis:names:tc:SAML:1.0:cm:holder-of-key"};
            Element keyInfoElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
            ((OMElement)keyInfoContent).declareNamespace("http://www.w3.org/2000/09/xmldsig#", "ds");
            ((OMElement)keyInfoContent).declareNamespace("http://www.w3.org/2001/04/xmlenc#", "xenc");
            keyInfoElem.appendChild(keyInfoContent);
            SAMLSubject subject = new SAMLSubject(subjectNameId, Arrays.asList(confirmationMethods), null, (Object)keyInfoElem);
            SAMLAttribute[] attrs = null;
            if (config.getCallbackHandler() != null) {
                cb = new SAMLAttributeCallback(data);
                handler = config.getCallbackHandler();
                handler.handle(cb);
                attrs = cb.getAttributes();
            } else if (config.getCallbackHandlerName() != null && config.getCallbackHandlerName().trim().length() > 0) {
                cb = new SAMLAttributeCallback(data);
                handler = null;
                MessageContext msgContext = data.getInMessageContext();
                ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
                Class cbClass = null;
                try {
                    cbClass = Loader.loadClass((ClassLoader)classLoader, (String)config.getCallbackHandlerName());
                }
                catch (ClassNotFoundException e) {
                    throw new TrustException("cannotLoadPWCBClass", new String[]{config.getCallbackHandlerName()}, e);
                }
                try {
                    handler = (SAMLCallbackHandler)cbClass.newInstance();
                }
                catch (Exception e) {
                    throw new TrustException("cannotCreatePWCBInstance", new String[]{config.getCallbackHandlerName()}, e);
                }
                handler.handle(cb);
                attrs = cb.getAttributes();
            } else {
                SAMLAttribute attribute = new SAMLAttribute("Name", "https://rahas.apache.org/saml/attrns", null, -1L, Arrays.asList("Colombo/Rahas"));
                attrs = new SAMLAttribute[]{attribute};
            }
            List<SAMLAttribute> attributeList = Arrays.asList(attrs);
            if (data.getActAs() != null) {
                SAMLAttribute actAsAttribute = new SAMLAttribute("ActAs", "https://rahas.apache.org/saml/attrns", null, -1L, Arrays.asList(data.getActAs()));
                attributeList.add(actAsAttribute);
            }
            SAMLAttributeStatement attrStmt = new SAMLAttributeStatement(subject, attributeList);
            SAMLStatement[] statements = new SAMLStatement[]{attrStmt};
            ArrayList<SAMLAudienceRestrictionCondition> conditions = null;
            if (StringUtils.isNotBlank((String)this.audienceRestriction)) {
                SAMLAudienceRestrictionCondition audienceRestriction = new SAMLAudienceRestrictionCondition();
                audienceRestriction.addAudience(this.audienceRestriction);
                conditions = new ArrayList<SAMLAudienceRestrictionCondition>();
                conditions.add(audienceRestriction);
            }
            SAMLAssertion assertion = new SAMLAssertion(config.issuerName, notBefore, notAfter, conditions, null, Arrays.asList(statements));
            X509Certificate[] issuerCerts = crypto.getCertificates(config.issuerKeyAlias);
            String sigAlgo = SAMLUtils.getSignatureAlgorithm(config, issuerCerts);
            PrivateKey issuerPK = crypto.getPrivateKey(config.issuerKeyAlias, config.issuerKeyPassword);
            assertion.sign(sigAlgo, (Key)issuerPK, Arrays.asList(issuerCerts));
            return assertion;
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    protected SAMLAssertion createAuthAssertion(Document doc, String confMethod, SAMLNameIdentifier subjectNameId, Element keyInfoContent, SAMLTokenIssuerConfig config, Crypto crypto, Date notBefore, Date notAfter, RahasData data) throws TrustException {
        try {
            String[] confirmationMethods = new String[]{confMethod};
            Element keyInfoElem = null;
            if (keyInfoContent != null) {
                keyInfoElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                ((OMElement)keyInfoContent).declareNamespace("http://www.w3.org/2000/09/xmldsig#", "ds");
                ((OMElement)keyInfoContent).declareNamespace("http://www.w3.org/2001/04/xmlenc#", "xenc");
                keyInfoElem.appendChild(keyInfoContent);
            }
            SAMLSubject subject = new SAMLSubject(subjectNameId, Arrays.asList(confirmationMethods), null, (Object)keyInfoElem);
            ArrayList<Object> statements = new ArrayList<Object>();
            SAMLAuthenticationStatement authStmt = new SAMLAuthenticationStatement(subject, "urn:oasis:names:tc:SAML:1.0:am:password", notBefore, null, null, null);
            statements.add(authStmt);
            SAMLAttributeStatement attrStatement = this.createSAMLAttributeStatement((SAMLSubject)subject.clone(), data, config);
            if (attrStatement != null) {
                statements.add(attrStatement);
            }
            ArrayList<SAMLAudienceRestrictionCondition> conditions = null;
            if (StringUtils.isNotBlank((String)this.audienceRestriction)) {
                SAMLAudienceRestrictionCondition audienceRestriction = new SAMLAudienceRestrictionCondition();
                audienceRestriction.addAudience(this.audienceRestriction);
                conditions = new ArrayList<SAMLAudienceRestrictionCondition>();
                conditions.add(audienceRestriction);
            }
            SAMLAssertion assertion = new SAMLAssertion(config.issuerName, notBefore, notAfter, conditions, null, statements);
            X509Certificate[] issuerCerts = crypto.getCertificates(config.issuerKeyAlias);
            String sigAlgo = SAMLUtils.getSignatureAlgorithm(config, issuerCerts);
            PrivateKey issuerPK = crypto.getPrivateKey(config.issuerKeyAlias, config.issuerKeyPassword);
            assertion.sign(sigAlgo, (Key)issuerPK, Arrays.asList(issuerCerts));
            return assertion;
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    @Override
    public String getResponseAction(RahasData data) throws TrustException {
        return TrustUtil.getActionValue(data.getVersion(), "/RSTRC/IssueFinal");
    }

    protected byte[] generateEphemeralKey(int keySize) throws TrustException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[keySize / 8];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new TrustException("Error in creating the ephemeral key", e);
        }
    }

    @Override
    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    @Override
    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }

    private SAMLAttributeStatement createSAMLAttributeStatement(SAMLSubject subject, RahasData rahasData, SAMLTokenIssuerConfig config) throws TrustException {
        try {
            SAMLAttributeCallback cb;
            SAMLAttribute[] attrs = null;
            if (config.getCallbackHandler() != null) {
                cb = new SAMLAttributeCallback(rahasData);
                SAMLCallbackHandler handler = config.getCallbackHandler();
                handler.handle(cb);
                attrs = cb.getAttributes();
            } else if (config.getCallbackHandlerName() != null && config.getCallbackHandlerName().trim().length() > 0) {
                cb = new SAMLAttributeCallback(rahasData);
                SAMLCallbackHandler handler = null;
                MessageContext msgContext = rahasData.getInMessageContext();
                ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
                Class cbClass = null;
                try {
                    cbClass = Loader.loadClass((ClassLoader)classLoader, (String)config.getCallbackHandlerName());
                }
                catch (ClassNotFoundException e) {
                    throw new TrustException("cannotLoadPWCBClass", new String[]{config.getCallbackHandlerName()}, e);
                }
                try {
                    handler = (SAMLCallbackHandler)cbClass.newInstance();
                }
                catch (Exception e) {
                    throw new TrustException("cannotCreatePWCBInstance", new String[]{config.getCallbackHandlerName()}, e);
                }
                handler.handle(cb);
                attrs = cb.getAttributes();
            }
            SAMLAttributeStatement attributeStatement = null;
            if (!ArrayUtils.isEmpty(attrs)) {
                attributeStatement = new SAMLAttributeStatement(subject, Arrays.asList(attrs));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SAML 1.1 attribute statement is constructed successfully.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No requested attributes found for SAML 1.1 attribute statement");
            }
            return attributeStatement;
        }
        catch (SAMLException e) {
            throw new TrustException(e.getMessage(), e);
        }
    }
}

