/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOMImplementationImpl;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOOMDocumentBuilder
extends DocumentBuilder {
    private final Schema schema;

    protected DOOMDocumentBuilder(Schema schema) {
        this.schema = schema;
    }

    @Override
    public boolean isNamespaceAware() {
        return true;
    }

    @Override
    public boolean isValidating() {
        return true;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return new DOMImplementationImpl();
    }

    @Override
    public Document newDocument() {
        OMDOMFactory factory = new OMDOMFactory();
        DocumentImpl documentImpl = new DocumentImpl((OMFactory)factory);
        documentImpl.setComplete(true);
        return documentImpl;
    }

    @Override
    public void setEntityResolver(EntityResolver arg0) {
    }

    @Override
    public void setErrorHandler(ErrorHandler arg0) {
    }

    @Override
    public Document parse(InputSource inputSource) throws SAXException, IOException {
        try {
            OMDOMFactory factory = new OMDOMFactory();
            XMLStreamReader reader = StAXUtils.createXMLStreamReader((Reader)inputSource.getCharacterStream());
            StAXOMBuilder builder = new StAXOMBuilder((OMFactory)factory, reader);
            DocumentImpl doc = (DocumentImpl)builder.getDocument();
            doc.close(true);
            return doc;
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public Document parse(InputStream is) throws SAXException, IOException {
        try {
            OMDOMFactory factory = new OMDOMFactory();
            XMLStreamReader reader = StAXUtils.createXMLStreamReader((InputStream)is);
            StAXOMBuilder builder = new StAXOMBuilder((OMFactory)factory, reader);
            DocumentImpl doc = (DocumentImpl)builder.getDocument();
            doc.close(true);
            return doc;
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document parse(File file) throws SAXException, IOException {
        try (FileInputStream in = new FileInputStream(file);){
            Document document = this.parse(in);
            return document;
        }
    }

    @Override
    public Document parse(InputStream is, String systemId) throws SAXException, IOException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Document parse(String uri) throws SAXException, IOException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }
}

