/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.security.SecureRandom;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.rahas.Rahas;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenPersister;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.AbstractIssuerConfig;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TokenIssuerUtil {
    public static final String ENCRYPTED_KEY = "EncryptedKey";
    public static final String BINARY_SECRET = "BinarySecret";

    public static byte[] getSharedSecret(RahasData data, int keyComputation, int keySize) throws TrustException {
        boolean reqEntrPresent = data.getRequestEntropy() != null;
        try {
            if (reqEntrPresent && keyComputation != 3) {
                if (keyComputation == 2) {
                    data.setResponseEntropy(WSSecurityUtil.generateNonce((int)(keySize / 8)));
                    P_SHA1 p_sha1 = new P_SHA1();
                    return p_sha1.createKey(data.getRequestEntropy(), data.getResponseEntropy(), 0, (long)(keySize / 8));
                }
                return data.getRequestEntropy();
            }
            return TokenIssuerUtil.generateEphemeralKey(keySize);
        }
        catch (WSSecurityException e) {
            throw new TrustException("errorCreatingSymmKey", e);
        }
        catch (ConversationException e) {
            throw new TrustException("errorCreatingSymmKey", e);
        }
    }

    public static void handleRequestedProofToken(RahasData data, int wstVersion, AbstractIssuerConfig config, OMElement rstrElem, Token token, Document doc) throws TrustException {
        OMElement reqProofTokElem = TrustUtil.createRequestedProofTokenElement(wstVersion, rstrElem);
        if (config.keyComputation == 2 && data.getRequestEntropy() != null) {
            OMElement respEntrElem = TrustUtil.createEntropyElement(wstVersion, rstrElem);
            String entr = Base64.encode((byte[])data.getResponseEntropy());
            OMElement binSecElem = TrustUtil.createBinarySecretElement(wstVersion, respEntrElem, "/Nonce");
            binSecElem.setText(entr);
            OMElement compKeyElem = TrustUtil.createComputedKeyElement(wstVersion, reqProofTokElem);
            compKeyElem.setText(data.getWstNs() + "/CK/PSHA1");
        } else if (ENCRYPTED_KEY.equals(config.proofKeyType)) {
            WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
            Crypto crypto = config.cryptoElement != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(config.cryptoElement), (ClassLoader)data.getInMessageContext().getAxisService().getClassLoader()) : CryptoFactory.getInstance((String)config.cryptoPropertiesFile, (ClassLoader)data.getInMessageContext().getAxisService().getClassLoader());
            encrKeyBuilder.setKeyIdentifierType(8);
            try {
                encrKeyBuilder.setUseThisCert(data.getClientCert());
                encrKeyBuilder.prepare(doc, crypto);
            }
            catch (WSSecurityException e) {
                throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", new String[]{data.getClientCert().getSubjectDN().getName()});
            }
            Element encryptedKeyElem = encrKeyBuilder.getEncryptedKeyElement();
            Element bstElem = encrKeyBuilder.getBinarySecurityTokenElement();
            if (bstElem != null) {
                reqProofTokElem.addChild((OMNode)((OMElement)bstElem));
            }
            reqProofTokElem.addChild((OMNode)((OMElement)encryptedKeyElem));
            token.setSecret(encrKeyBuilder.getEphemeralKey());
        } else if (BINARY_SECRET.equals(config.proofKeyType)) {
            byte[] secret = TokenIssuerUtil.getSharedSecret(data, config.keyComputation, config.keySize);
            OMElement binSecElem = TrustUtil.createBinarySecretElement(wstVersion, reqProofTokElem, null);
            binSecElem.setText(Base64.encode((byte[])secret));
            token.setSecret(secret);
        } else {
            throw new IllegalArgumentException(config.proofKeyType);
        }
    }

    private static byte[] generateEphemeralKey(int keySize) throws TrustException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[keySize / 8];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new TrustException("errorCreatingSymmKey", e);
        }
    }

    public static boolean isPersisterConfigured(AbstractIssuerConfig samlIssuerConfig) {
        return ((SAMLTokenIssuerConfig)samlIssuerConfig).getPersisterClassName() != null;
    }

    public static void setIssuerConfigInConfigCtx(AbstractIssuerConfig samlIssuerConfig, MessageContext msgCxt) {
        msgCxt.getConfigurationContext().setProperty("IssuerConfig", (Object)samlIssuerConfig);
    }

    public static TokenPersister getTokenPersister(AbstractIssuerConfig config, MessageContext inMsgCtx) throws TrustException {
        TokenPersister tokenPersister = null;
        if (((SAMLTokenIssuerConfig)config).getPersisterClassName() != null) {
            String persisterClassName = ((SAMLTokenIssuerConfig)config).getPersisterClassName();
            try {
                Class persisterCalss = Loader.loadClass((ClassLoader)inMsgCtx.getAxisService().getClassLoader(), (String)persisterClassName);
                tokenPersister = (TokenPersister)persisterCalss.newInstance();
                tokenPersister.setConfiguration(config);
                tokenPersister.setMessageContext(inMsgCtx);
            }
            catch (ClassNotFoundException e) {
                String errorMsg = "Can not load the class" + persisterClassName;
                throw new TrustException(errorMsg, e);
            }
            catch (InstantiationException e) {
                String errorMessage = "Can not create token persister instance.";
                throw new TrustException(errorMessage, e);
            }
            catch (IllegalAccessException e) {
                String errorMessage = "Can not create token persister instance.";
                throw new TrustException(errorMessage, e);
            }
        }
        return tokenPersister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void manageTokenPersistenceSettings(AbstractIssuerConfig config, MessageContext inMsgCtx) throws TrustException {
        try {
            Class<TokenIssuerUtil> clazz;
            ConfigurationContext configCtx = inMsgCtx.getConfigurationContext();
            if (configCtx.getProperty("org.apache.rahas.TokenPersister") == null) {
                TokenPersister tokenPersister;
                clazz = TokenIssuerUtil.class;
                // MONITORENTER : org.apache.rahas.impl.TokenIssuerUtil.class
                if (configCtx.getProperty("org.apache.rahas.TokenPersister") == null && (tokenPersister = TokenIssuerUtil.getTokenPersister(config, inMsgCtx)) != null) {
                    configCtx.setProperty("org.apache.rahas.TokenPersister", (Object)tokenPersister);
                    if (configCtx.getProperty("org.apache.rahas.TokenStorage") != null) {
                        Rahas.setPersistanceStorage(tokenPersister, (TokenStorage)configCtx.getProperty("org.apache.rahas.TokenStorage"));
                    }
                }
                // MONITOREXIT : clazz
            }
            if (configCtx.getProperty("IssuerConfig") != null) return;
            clazz = TokenIssuerUtil.class;
            // MONITORENTER : org.apache.rahas.impl.TokenIssuerUtil.class
            if (configCtx.getProperty("IssuerConfig") == null) {
                TokenIssuerUtil.setIssuerConfigInConfigCtx(config, inMsgCtx);
            }
            // MONITOREXIT : clazz
            return;
        }
        catch (TrustException e) {
            throw new TrustException("Error in initializing persister settings.", e);
        }
    }
}

