/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAML2TokenIssuer;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.opensaml.saml.saml2.core.Assertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class SAML2PassiveTokenIssuer
extends SAML2TokenIssuer {
    private SAMLTokenIssuerConfig config = null;
    private RahasData data = null;

    public void setConfig(SAMLTokenIssuerConfig config) {
        this.config = config;
    }

    public OMElement issuePassiveRSTR(RahasData data) throws TrustException {
        MessageContext inMsgCtx = data.getInMessageContext();
        this.data = data;
        SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
        Crypto crypto = this.config.cryptoElement != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(this.config.cryptoElement), (ClassLoader)inMsgCtx.getAxisService().getClassLoader()) : (this.config.cryptoPropertiesElement != null && this.config.cryptoPropertiesElement.getFirstElement() != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(this.config.cryptoPropertiesElement.getFirstElement()), (ClassLoader)inMsgCtx.getAxisService().getClassLoader()) : CryptoFactory.getInstance((String)this.config.cryptoPropertiesFile, (ClassLoader)inMsgCtx.getAxisService().getClassLoader()));
        Date creationTime = new Date();
        Date expirationTime = new Date();
        expirationTime.setTime(creationTime.getTime() + this.config.ttl);
        Document doc = ((Element)env).getOwnerDocument();
        int keySize = data.getKeysize();
        keySize = keySize == -1 ? this.config.keySize : keySize;
        Assertion assertion = null;
        assertion = this.createBearerAssersion(this.config, doc, crypto, data);
        OMElement rstrcElem = null;
        OMElement rstrElem = null;
        int wstVersion = data.getVersion();
        if (1 == wstVersion) {
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
        } else {
            rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
        }
        TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        if (this.config.addRequestedAttachedRef) {
            TrustUtil.createRequestedAttachedRef(wstVersion, rstrElem, "#" + assertion.getID(), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        if (this.config.addRequestedUnattachedRef) {
            TrustUtil.createRequestedUnattachedRef(wstVersion, rstrElem, assertion.getID(), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        if (data.getAppliesToAddress() != null) {
            TrustUtil.createAppliesToElement(rstrElem, data.getAppliesToAddress(), data.getAddressingNs());
        }
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        TrustUtil.createLifetimeElement(wstVersion, rstrElem, zulu.format(creationTime), zulu.format(expirationTime));
        OMElement reqSecTokenElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
        Element tempNode = assertion.getDOM();
        Element element = assertion.getDOM();
        ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
        DOMImplementationRegistry registry = null;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new TrustException("errorCreatingSAMLToken", new String[]{assertion.getID()}, e);
        }
        catch (InstantiationException e) {
            throw new TrustException("errorCreatingSAMLToken", new String[]{assertion.getID()}, e);
        }
        catch (IllegalAccessException e) {
            throw new TrustException("errorCreatingSAMLToken", new String[]{assertion.getID()}, e);
        }
        catch (ClassCastException e) {
            throw new TrustException("errorCreatingSAMLToken", new String[]{assertion.getID()}, e);
        }
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer writer = impl.createLSSerializer();
        LSOutput output = impl.createLSOutput();
        output.setByteStream(byteArrayOutputStrm);
        writer.write(element, output);
        String elementString = byteArrayOutputStrm.toString();
        OMElement assertionElement = null;
        try {
            assertionElement = AXIOMUtil.stringToOM((String)elementString);
        }
        catch (XMLStreamException e) {
            throw new TrustException("errorCreatingSAMLToken", new String[]{assertion.getID()}, e);
        }
        reqSecTokenElem.addChild((OMNode)((Element)rstrElem).getOwnerDocument().importNode(tempNode, true));
        Token assertionToken = new Token(assertion.getID(), assertionElement, creationTime, expirationTime);
        assertionToken.setSecret(data.getEphmeralKey());
        if (!this.config.isTokenStoreDisabled()) {
            assertionToken.setPersistenceEnabled(true);
            TrustUtil.getTokenStore(inMsgCtx).add(assertionToken);
        }
        if (rstrcElem != null) {
            return rstrcElem;
        }
        return rstrElem;
    }

    public void setAudienceRestrictionCondition(String audienceRestriction) throws TrustException {
        this.audienceRestriction = audienceRestriction;
    }
}

