/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenRenewer;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.rahas.impl.util.SAMLUtils;
import org.apache.rahas.impl.util.SignKeyHolder;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.Base64;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLObjectContentReference;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.impl.ConditionsBuilder;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;
import org.xml.sax.SAXException;

public class SAML2TokenRenewer
implements TokenRenewer {
    private String configParamName;
    private OMElement configElement;
    private String configFile;
    protected List<Signature> signatureList = new ArrayList<Signature>();
    private static final Log log = LogFactory.getLog(SAML2TokenRenewer.class);

    @Override
    public SOAPEnvelope renew(RahasData data) throws TrustException {
        MessageContext inMsgCtx = data.getInMessageContext();
        TokenStorage tkStorage = TrustUtil.getTokenStore(inMsgCtx);
        SAMLTokenIssuerConfig config = this.setConfig(inMsgCtx);
        SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
        OMElement rstrElem = this.buildResponse(inMsgCtx, data, env, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        int wstVersion = data.getVersion();
        Date creationTime = new Date();
        Date expirationTime = new Date();
        expirationTime.setTime(creationTime.getTime() + config.ttl);
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        TrustUtil.createLifetimeElement(wstVersion, rstrElem, zulu.format(creationTime), zulu.format(expirationTime));
        Token tk = tkStorage.getToken(data.getTokenId());
        OMElement assertionOMElement = tk.getToken();
        if (!TrustUtil.isDoomParserPoolUsed() && DocumentBuilderFactoryImpl.isDOOMRequired()) {
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
        }
        String s = assertionOMElement.toString();
        DocumentBuilderFactory documentBuilderFactory = TrustUtil.getSecuredDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = null;
        try {
            Crypto crypto = this.getCrypto(inMsgCtx, config);
            docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(s.trim().getBytes()));
            Element element = document.getDocumentElement();
            SAMLInitializer.doBootstrap();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            Assertion samlAssertion = (Assertion)unmarshaller.unmarshall(element);
            DateTime creationDate = new DateTime();
            DateTime expirationDate = new DateTime(creationDate.getMillis() + config.ttl);
            Conditions conditions = new ConditionsBuilder().buildObject();
            conditions.setNotBefore(creationDate);
            conditions.setNotOnOrAfter(expirationDate);
            samlAssertion.setConditions(conditions);
            SignKeyHolder signKeyHolder = this.createSignKeyHolder(config, crypto);
            Assertion signedAssertion = this.signAssertion(samlAssertion, signKeyHolder);
            OMElement reqSecTokenElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
            Element tempNode = signedAssertion.getDOM();
            reqSecTokenElem.addChild((OMNode)((Element)rstrElem).getOwnerDocument().importNode(tempNode, true));
        }
        catch (ParserConfigurationException e) {
            throw new TrustException("Cannot create SAML 2.0 Assertion", e);
        }
        catch (SAXException e) {
            throw new TrustException("Cannot create SAML 2.0 Assertion", e);
        }
        catch (UnmarshallingException e) {
            throw new TrustException("Cannot create SAML 2.0 Assertion", e);
        }
        catch (InitializationException e) {
            throw new TrustException("Cannot create SAML 2.0 Assertion", e);
        }
        catch (IOException e) {
            throw new TrustException("Cannot create SAML 2.0 Assertion", e);
        }
        return env;
    }

    private SignKeyHolder createSignKeyHolder(SAMLTokenIssuerConfig config, Crypto crypto) throws TrustException {
        SignKeyHolder signKeyHolder = new SignKeyHolder();
        try {
            java.security.cert.X509Certificate[] issuerCerts = crypto.getCertificates(config.issuerKeyAlias);
            String sigAlgo = SAMLUtils.getSignatureAlgorithm(config, issuerCerts);
            String digestAlgorithm = SAMLUtils.getDigestAlgorithm(config);
            PrivateKey issuerPK = crypto.getPrivateKey(config.issuerKeyAlias, config.issuerKeyPassword);
            signKeyHolder.setIssuerCerts(issuerCerts);
            signKeyHolder.setIssuerPK(issuerPK);
            signKeyHolder.setSignatureAlgorithm(sigAlgo);
            signKeyHolder.setDigestAlgorithm(digestAlgorithm);
        }
        catch (WSSecurityException e) {
            throw new TrustException("Cannot create SAML 2.0 Assertion", e);
        }
        catch (Exception e) {
            throw new TrustException("Cannot create SAML 2.0 Assertion", e);
        }
        return signKeyHolder;
    }

    private Assertion signAssertion(Assertion assertion, SignKeyHolder cred) throws TrustException {
        Signature signature = (Signature)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME).buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)cred);
        signature.setSignatureAlgorithm(cred.getSignatureAlgorithm());
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setSigningCredential((Credential)cred);
        try {
            KeyInfo keyInfo = (KeyInfo)SAML2TokenRenewer.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data data = (X509Data)SAML2TokenRenewer.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
            X509Certificate cert = (X509Certificate)SAML2TokenRenewer.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
            String value = Base64.encode((byte[])cred.getEntityCertificate().getEncoded());
            cert.setValue(value);
            data.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(data);
            signature.setKeyInfo(keyInfo);
            assertion.setSignature(signature);
            String digestAlgorithm = cred.getDigestAlgorithm();
            if (StringUtils.isNotBlank((String)digestAlgorithm) && signature.getContentReferences() != null && !signature.getContentReferences().isEmpty()) {
                ((SAMLObjectContentReference)signature.getContentReferences().get(0)).setDigestAlgorithm(digestAlgorithm);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Selected '" + digestAlgorithm + "' as the digest algorithm."));
                }
            }
            this.signatureList.add(signature);
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)assertion);
            Element assertionElem = marshaller.marshall((XMLObject)assertion);
            Init.init();
            Signer.signObjects(this.signatureList);
        }
        catch (MarshallingException e) {
            throw new TrustException("Cannot create SAML 2.0 Assertion", e);
        }
        catch (Exception e) {
            throw new TrustException("Cannot create SAML 2.0 Assertion", e);
        }
        return assertion;
    }

    protected static XMLObject buildXMLObject(QName objectQName) throws Exception {
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new TrustException("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    protected SAMLTokenIssuerConfig setConfig(MessageContext inMsgCtx) throws TrustException {
        SAMLTokenIssuerConfig config = null;
        if (this.configElement != null) {
            config = new SAMLTokenIssuerConfig(this.configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
        }
        if (config == null && this.configFile != null) {
            config = new SAMLTokenIssuerConfig(this.configFile);
        }
        if (config == null && this.configParamName != null) {
            Parameter param = inMsgCtx.getParameter(this.configParamName);
            if (param != null && param.getParameterElement() != null) {
                config = new SAMLTokenIssuerConfig(param.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
            } else {
                throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
            }
        }
        if (config == null) {
            throw new TrustException("configurationIsNull");
        }
        if (config.isTokenStoreDisabled()) {
            throw new TrustException("errorTokenStoreDisabled");
        }
        if (TokenIssuerUtil.isPersisterConfigured(config)) {
            TokenIssuerUtil.manageTokenPersistenceSettings(config, inMsgCtx);
        }
        return config;
    }

    protected OMElement buildResponse(MessageContext inMsgCtx, RahasData data, SOAPEnvelope env, String tokenType) throws TrustException {
        OMElement rstrElem;
        int wstVersion = data.getVersion();
        if (1 == wstVersion) {
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
        } else {
            OMElement rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
        }
        TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText(tokenType);
        return rstrElem;
    }

    protected Crypto getCrypto(MessageContext inMsgCtx, SAMLTokenIssuerConfig config) {
        Crypto crypto = config.cryptoElement != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(config.cryptoElement), (ClassLoader)inMsgCtx.getAxisService().getClassLoader()) : CryptoFactory.getInstance((String)config.cryptoPropertiesFile, (ClassLoader)inMsgCtx.getAxisService().getClassLoader());
        return crypto;
    }

    @Override
    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    @Override
    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }
}

