/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl.util;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;

public class SAMLUtils {
    public static Collection<X509Certificate> getCertChainCollection(X509Certificate[] issuerCerts) {
        ArrayList<X509Certificate> certCollection = new ArrayList<X509Certificate>();
        if (issuerCerts == null) {
            return certCollection;
        }
        for (X509Certificate cert : issuerCerts) {
            certCollection.add(cert);
        }
        return certCollection;
    }

    public static String getSignatureAlgorithm(SAMLTokenIssuerConfig config, X509Certificate[] issuerCerts) {
        String pubKeyAlgo;
        String sigAlgo = config.getSignatureAlgorithm();
        if (sigAlgo == null || sigAlgo.isEmpty()) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        if ((pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm()).equalsIgnoreCase("DSA")) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        return sigAlgo;
    }

    public static String getDigestAlgorithm(SAMLTokenIssuerConfig config) {
        String digestAlgorithm = config.getDigestAlgorithm();
        if (digestAlgorithm == null || digestAlgorithm.isEmpty()) {
            digestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        return digestAlgorithm;
    }
}

