/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hive.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hive.client.HiveClient;
import org.apache.ranger.services.hive.client.HiveConnectionMgr;

public class HiveResourceMgr {
    public static final Logger LOG = Logger.getLogger(HiveResourceMgr.class);
    private static final String DATABASE = "database";
    private static final String TABLE = "table";
    private static final String UDF = "udf";
    private static final String COLUMN = "column";

    public static HashMap<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        HashMap<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HiveResourceMgr.connectionTest ServiceName: " + serviceName + "Configs" + configs));
        }
        try {
            ret = HiveClient.connectionTest(serviceName, configs);
        }
        catch (HadoopException e) {
            LOG.error((Object)("<== HiveResourceMgr.connectionTest Error: " + (Object)((Object)e)));
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveResourceMgr.connectionTest Result : " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHiveResources(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List columnList;
        List tableList;
        List databaseList;
        List resultList;
        String userInput;
        block27: {
            userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            databaseList = null;
            tableList = null;
            columnList = null;
            String databaseName = null;
            String tableName = null;
            String columnName = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== HiveResourceMgr.getHiveResources()  UserInput: \"" + userInput + "\" resource : " + resource + " resourceMap: " + resourceMap));
            }
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    databaseList = (List)resourceMap.get(DATABASE);
                    tableList = (List)resourceMap.get(TABLE);
                    columnList = (List)resourceMap.get(COLUMN);
                }
                switch (resource.trim().toLowerCase()) {
                    case "database": {
                        databaseName = userInput;
                        break;
                    }
                    case "table": {
                        tableName = userInput;
                        break;
                    }
                    case "column": {
                        columnName = userInput;
                        break;
                    }
                }
            }
            if (serviceName != null && userInput != null) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("==> HiveResourceMgr.getHiveResources() UserInput: " + userInput + " configs: " + configs + " databaseList: " + databaseList + " tableList: " + tableList + " columnList: " + columnList));
                    }
                    final HiveClient hiveClient = new HiveConnectionMgr().getHiveConnection(serviceName, serviceType, configs);
                    Callable<List<String>> callableObj = null;
                    final List finaldatabaseList = databaseList;
                    final List finaltableList = tableList;
                    final List finalcolumnList = columnList;
                    if (hiveClient == null) break block27;
                    if (databaseName != null && !databaseName.isEmpty()) {
                        final String finalDbName = databaseName = databaseName + "*";
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                return hiveClient.getDatabaseList(finalDbName, finaldatabaseList);
                            }
                        };
                    } else if (tableName != null && !tableName.isEmpty()) {
                        final String finalTableName = tableName = tableName + "*";
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                return hiveClient.getTableList(finalTableName, finaldatabaseList, finaltableList);
                            }
                        };
                    } else if (columnName != null && !columnName.isEmpty()) {
                        final String finalColName = columnName = columnName + "*";
                        String finalDbName = databaseName;
                        String finalTableName = tableName;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                return hiveClient.getColumnList(finalColName, finaldatabaseList, finaltableList, finalcolumnList);
                            }
                        };
                    }
                    if (callableObj != null) {
                        HiveClient hiveClient2 = hiveClient;
                        synchronized (hiveClient2) {
                            resultList = (List)TimedEventUtil.timedTask(callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                            break block27;
                        }
                    }
                    LOG.error((Object)"Could not initiate at timedTask");
                }
                catch (Exception e) {
                    LOG.error((Object)"Unable to get hive resources.", (Throwable)e);
                    throw e;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveResourceMgr.getHiveResources() UserInput: " + userInput + " configs: " + configs + " databaseList: " + databaseList + " tableList: " + tableList + " columnList: " + columnList + "Result :" + resultList));
        }
        return resultList;
    }
}

