/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;

class HiveObj {
    String databaseName;
    String tableName;

    HiveObj(HiveAuthzContext context) {
        this.fetchHiveObj(context);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    private void fetchHiveObj(HiveAuthzContext context) {
        Object[] cmd;
        String cmdString;
        if (context != null && (cmdString = context.getCommandString()) != null && !ArrayUtils.isEmpty((Object[])(cmd = cmdString.trim().split("\\s+"))) && cmd.length > 2) {
            Object dbName = cmd[2];
            if (((String)dbName).contains(".")) {
                String[] result = this.splitDBName((String)dbName);
                this.databaseName = result[0];
                this.tableName = result[1];
            } else {
                this.databaseName = dbName;
                this.tableName = null;
            }
        }
    }

    private String[] splitDBName(String dbName) {
        String[] ret = null;
        ret = dbName.split("\\.");
        return ret;
    }
}

