/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.AbstractHiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.DisallowTransformHook;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.SettableConfigUpdater;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.utils.StringUtil;

public abstract class RangerHiveAuthorizerBase
extends AbstractHiveAuthorizer {
    private static final Log LOG = LogFactory.getLog(RangerHiveAuthorizerBase.class);
    private HiveMetastoreClientFactory mMetastoreClientFactory;
    private HiveConf mHiveConf;
    private HiveAuthenticationProvider mHiveAuthenticator;
    private HiveAuthzSessionContext mSessionContext;
    private UserGroupInformation mUgi;

    public RangerHiveAuthorizerBase(HiveMetastoreClientFactory metastoreClientFactory, HiveConf hiveConf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext context) {
        this.mMetastoreClientFactory = metastoreClientFactory;
        this.mHiveConf = hiveConf;
        this.mHiveAuthenticator = hiveAuthenticator;
        this.mSessionContext = context;
        String userName = this.mHiveAuthenticator == null ? null : this.mHiveAuthenticator.getUserName();
        UserGroupInformation userGroupInformation = this.mUgi = userName == null ? null : UserGroupInformation.createRemoteUser((String)userName);
        if (this.mHiveAuthenticator == null) {
            LOG.warn((Object)"RangerHiveAuthorizerBase.RangerHiveAuthorizerBase(): hiveAuthenticator is null");
        } else if (StringUtil.isEmpty((String)userName)) {
            LOG.warn((Object)"RangerHiveAuthorizerBase.RangerHiveAuthorizerBase(): hiveAuthenticator.getUserName() returned null/empty");
        } else if (this.mUgi == null) {
            LOG.warn((Object)String.format("RangerHiveAuthorizerBase.RangerHiveAuthorizerBase(): UserGroupInformation.createRemoteUser(%s) returned null", userName));
        }
    }

    public HiveMetastoreClientFactory getMetastoreClientFactory() {
        return this.mMetastoreClientFactory;
    }

    public HiveConf getHiveConf() {
        return this.mHiveConf;
    }

    public HiveAuthenticationProvider getHiveAuthenticator() {
        return this.mHiveAuthenticator;
    }

    public HiveAuthzSessionContext getHiveAuthzSessionContext() {
        return this.mSessionContext;
    }

    public UserGroupInformation getCurrentUserGroupInfo() {
        return this.mUgi;
    }

    public void applyAuthorizationConfigPolicy(HiveConf hiveConf) throws HiveAuthzPluginException {
        LOG.debug((Object)"RangerHiveAuthorizerBase.applyAuthorizationConfigPolicy()");
        if (this.mSessionContext != null && this.mSessionContext.getClientType() == HiveAuthzSessionContext.CLIENT_TYPE.HIVESERVER2) {
            String hooks = hiveConf.getVar(HiveConf.ConfVars.PREEXECHOOKS).trim();
            hooks = hooks.isEmpty() ? DisallowTransformHook.class.getName() : hooks + "," + DisallowTransformHook.class.getName();
            hiveConf.setVar(HiveConf.ConfVars.PREEXECHOOKS, hooks);
            SettableConfigUpdater.setHiveConfWhiteList((HiveConf)hiveConf);
        }
    }

    public List<HivePrivilegeInfo> showPrivileges(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException, HiveAccessControlException {
        LOG.debug((Object)"RangerHiveAuthorizerBase.showPrivileges()");
        this.throwNotImplementedException("showPrivileges");
        return null;
    }

    public HiveAuthorizer.VERSION getVersion() {
        return HiveAuthorizer.VERSION.V1;
    }

    private void throwNotImplementedException(String method) throws HiveAuthzPluginException {
        throw new HiveAuthzPluginException(method + "() not implemented in Ranger AbstractHiveAuthorizer");
    }

    public HivePolicyProvider getHivePolicyProvider() throws HiveAuthzPluginException {
        return null;
    }
}

