/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import org.apache.ranger.authorization.hive.authorizer.HiveObjectType;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;

public class RangerHiveResource
extends RangerAccessResourceImpl {
    public static final String KEY_DATABASE = "database";
    public static final String KEY_TABLE = "table";
    public static final String KEY_UDF = "udf";
    public static final String KEY_COLUMN = "column";
    public static final String KEY_URL = "url";
    public static final String KEY_HIVESERVICE = "hiveservice";
    public static final String KEY_GLOBAL = "global";
    private HiveObjectType objectType = null;

    public RangerHiveResource(HiveObjectType objectType, String firstLevelResource) {
        this(objectType, firstLevelResource, null, null);
    }

    public RangerHiveResource(HiveObjectType objectType, String firstLevelResource, String secondLevelResource) {
        this(objectType, firstLevelResource, secondLevelResource, null);
    }

    public RangerHiveResource(HiveObjectType objectType, String firstLevelResource, String secondLevelResource, String thirdLevelResource) {
        this.objectType = objectType;
        switch (objectType) {
            case DATABASE: {
                this.setValue(KEY_DATABASE, firstLevelResource);
                break;
            }
            case FUNCTION: {
                if (firstLevelResource == null) {
                    firstLevelResource = "";
                }
                this.setValue(KEY_DATABASE, firstLevelResource);
                this.setValue(KEY_UDF, secondLevelResource);
                break;
            }
            case COLUMN: {
                this.setValue(KEY_DATABASE, firstLevelResource);
                this.setValue(KEY_TABLE, secondLevelResource);
                this.setValue(KEY_COLUMN, thirdLevelResource);
                break;
            }
            case TABLE: 
            case VIEW: 
            case INDEX: 
            case PARTITION: {
                this.setValue(KEY_DATABASE, firstLevelResource);
                this.setValue(KEY_TABLE, secondLevelResource);
                break;
            }
            case URI: {
                this.setValue(KEY_URL, firstLevelResource);
                break;
            }
            case SERVICE_NAME: {
                if (firstLevelResource == null) {
                    firstLevelResource = "";
                }
                this.setValue(KEY_HIVESERVICE, firstLevelResource);
                break;
            }
            case GLOBAL: {
                if (firstLevelResource == null) {
                    firstLevelResource = KEY_GLOBAL;
                }
                this.setValue(KEY_GLOBAL, firstLevelResource);
                break;
            }
        }
    }

    public HiveObjectType getObjectType() {
        return this.objectType;
    }

    public String getDatabase() {
        return (String)this.getValue(KEY_DATABASE);
    }

    public String getTable() {
        return (String)this.getValue(KEY_TABLE);
    }

    public String getUdf() {
        return (String)this.getValue(KEY_UDF);
    }

    public String getColumn() {
        return (String)this.getValue(KEY_COLUMN);
    }

    public String getUrl() {
        return (String)this.getValue(KEY_URL);
    }

    public String getHiveService() {
        return (String)this.getValue(KEY_HIVESERVICE);
    }
}

