/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.dao;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.log4j.Logger;
import org.apache.ranger.audit.dao.DaoManager;
import org.apache.ranger.audit.dao.DaoManagerBase;

public abstract class BaseDao<T> {
    static final Logger logger = Logger.getLogger(BaseDao.class);
    protected DaoManager daoManager;
    protected Class<T> tClass;

    public BaseDao(DaoManagerBase daoManager) {
        this.init(daoManager);
    }

    private void init(DaoManagerBase daoManager) {
        this.daoManager = (DaoManager)daoManager;
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type type = genericSuperclass.getActualTypeArguments()[0];
        this.tClass = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
    }

    public EntityManager getEntityManager() {
        return this.daoManager.getEntityManager();
    }

    public boolean beginTransaction() {
        EntityTransaction et;
        boolean ret = false;
        EntityManager em = this.getEntityManager();
        if (em != null && (et = em.getTransaction()) != null && !et.isActive()) {
            et.begin();
            ret = true;
        }
        return ret;
    }

    public void commitTransaction() {
        EntityManager em = this.getEntityManager();
        if (em != null) {
            em.flush();
            EntityTransaction et = em.getTransaction();
            if (et != null) {
                et.commit();
            }
        }
    }

    public void rollbackTransaction() {
        EntityTransaction et;
        EntityManager em = this.getEntityManager();
        if (em != null && (et = em.getTransaction()) != null) {
            et.rollback();
        }
    }

    public T create(T obj) {
        T ret = null;
        boolean trxBegan = this.beginTransaction();
        this.getEntityManager().persist(obj);
        if (trxBegan) {
            this.commitTransaction();
        }
        ret = obj;
        return ret;
    }

    public T update(T obj) {
        boolean trxBegan = this.beginTransaction();
        this.getEntityManager().merge(obj);
        if (trxBegan) {
            this.commitTransaction();
        }
        return obj;
    }

    public boolean remove(Long id) {
        return this.remove(this.getById(id));
    }

    public boolean remove(T obj) {
        if (obj == null) {
            return true;
        }
        boolean ret = false;
        boolean trxBegan = this.beginTransaction();
        this.getEntityManager().remove(obj);
        if (trxBegan) {
            this.commitTransaction();
        }
        ret = true;
        return ret;
    }

    public T getById(Long id) {
        if (id == null) {
            return null;
        }
        Object ret = null;
        try {
            ret = this.getEntityManager().find(this.tClass, (Object)id);
        }
        catch (NoResultException e) {
            return null;
        }
        return (T)ret;
    }

    public List<T> getAll() {
        List ret = null;
        TypedQuery qry = this.getEntityManager().createQuery("SELECT t FROM " + this.tClass.getSimpleName() + " t", this.tClass);
        ret = qry.getResultList();
        return ret;
    }

    public Long getAllCount() {
        Long ret = null;
        TypedQuery qry = this.getEntityManager().createQuery("SELECT count(t) FROM " + this.tClass.getSimpleName() + " t", Long.class);
        ret = (Long)qry.getSingleResult();
        return ret;
    }

    public T getUniqueResult(TypedQuery<T> qry) {
        Object ret = null;
        try {
            ret = qry.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return (T)ret;
    }

    public List<T> executeQuery(TypedQuery<T> qry) {
        List ret = null;
        ret = qry.getResultList();
        return ret;
    }

    public List<T> findByNamedQuery(String namedQuery, String paramName, Object refId) {
        List ret = new ArrayList();
        if (namedQuery == null) {
            return ret;
        }
        try {
            TypedQuery qry = this.getEntityManager().createNamedQuery(namedQuery, this.tClass);
            qry.setParameter(paramName, refId);
            ret = qry.getResultList();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return ret;
    }
}

